/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.hud.component.ArmorBarComponent;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.hud.component.CrosshairComponent;
import net.minecraft.client.gui.hud.component.FireBarComponent;
import net.minecraft.client.gui.hud.component.HealthBarComponent;
import net.minecraft.client.gui.hud.component.HotbarComponent;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.OxygenBarComponent;
import net.minecraft.client.gui.hud.component.RotationLockComponent;
import net.minecraft.client.gui.hud.component.SubtitleComponent;
import net.minecraft.client.gui.hud.component.layout.AbsoluteLayout;
import net.minecraft.client.gui.hud.component.layout.SnapLayout;
import org.slf4j.Logger;

public class HudComponents {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static String DEFAULT_LAYOUT = null;
    public static final HudComponents INSTANCE = new HudComponents();
    private final List<HudComponent> components = new ArrayList<HudComponent>();
    public static final HudComponent HOTBAR = HudComponents.register(new HotbarComponent("hotbar", new AbsoluteLayout(0.5f, 1.0f, ComponentAnchor.BOTTOM_CENTER)));
    public static final HudComponent CROSSHAIR = HudComponents.register(new CrosshairComponent("crosshair", new AbsoluteLayout(0.5f, 0.5f, ComponentAnchor.CENTER)));
    public static final HudComponent HEALTH_BAR = HudComponents.register(new HealthBarComponent("health_bar", new SnapLayout(HOTBAR, ComponentAnchor.TOP_LEFT, ComponentAnchor.BOTTOM_LEFT)));
    public static final HudComponent ARMOR_BAR = HudComponents.register(new ArmorBarComponent("armor_bar", new SnapLayout(HOTBAR, ComponentAnchor.TOP_RIGHT, ComponentAnchor.BOTTOM_RIGHT)));
    public static final HudComponent OXYGEN_BAR = HudComponents.register(new OxygenBarComponent("oxygen_bar", new SnapLayout(HEALTH_BAR, ComponentAnchor.TOP_LEFT, ComponentAnchor.BOTTOM_LEFT)));
    public static final HudComponent FIRE_BAR = HudComponents.register(new FireBarComponent("fire_bar", new SnapLayout(OXYGEN_BAR, ComponentAnchor.TOP_LEFT, ComponentAnchor.BOTTOM_LEFT)));
    public static final HudComponent ROTATION_LOCK = HudComponents.register(new RotationLockComponent("rotation_lock", new SnapLayout(CROSSHAIR, ComponentAnchor.CENTER_RIGHT, ComponentAnchor.CENTER_LEFT)));
    public static final HudComponent SUBTITLES = HudComponents.register(new SubtitleComponent("subtitles_box", 100, 50, new AbsoluteLayout(1.0f, 0.75f, ComponentAnchor.BOTTOM_RIGHT)));

    public static HudComponent register(HudComponent component) {
        HudComponents.INSTANCE.components.add(component);
        return component;
    }

    private HudComponents() {
    }

    public List<HudComponent> getComponents() {
        return this.components;
    }

    public HudComponent getComponent(String key) {
        for (HudComponent component : this.components) {
            if (!component.getKey().equals(key)) continue;
            return component;
        }
        return null;
    }

    public String toSettingsString() {
        StringBuilder builder = new StringBuilder();
        for (HudComponent component : this.components) {
            builder.append(component.toSettingsString()).append('|');
        }
        return builder.toString();
    }

    public void fromSettingsString(String settings) {
        String[] parts;
        for (String part : parts = settings.split("\\|")) {
            String key = part.substring(0, part.indexOf(123));
            HudComponent component = this.getComponent(key);
            if (component == null) {
                LOGGER.warn("Unknown component: {}", (Object)key);
                continue;
            }
            String componentSettings = part.substring(part.indexOf(123) + 1, part.lastIndexOf(125));
            component.fromSettingsString(componentSettings);
        }
    }
}

