/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.ModelViewerScreen;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.TextCycleElement;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.FallingBlockEntity;
import net.minecraft.core.world.World;

public class EntityFallingSandEntry
extends EntityEntry<FallingBlockEntity> {
    @Override
    public void onTick(FallingBlockEntity entity) {
    }

    @Override
    public List<ButtonElement> getEntryButtons(Minecraft mc, Screen parentScreen, final FallingBlockEntity sand) {
        final TextCycleElement<Integer> blockIdCycle = new TextCycleElement<Integer>(parentScreen, mc.font, -120, 0, 120, 20, Integer.valueOf(sand.blockID)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return ModelViewerScreen.cycleBlockId(current, offset);
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    if (Block.blocksList[id] != null) {
                        return id;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return sand.blockID;
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        blockIdCycle.textField.setPrefaceText("ID: ");
        blockIdCycle.textField.setPlaceholder("Block ID");
        blockIdCycle.setOnValueChanged(() -> {
            sand.blockID = (Integer)blockIdCycle.getCurrentElement();
        });
        return new ArrayList<ButtonElement>(){
            {
                this.add(blockIdCycle);
            }
        };
    }

    @Override
    public FallingBlockEntity getEntityInstance(Minecraft mc, World world) {
        return new FallingBlockEntity(world);
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onClose() {
    }
}

