/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.blockentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.FlagRenderer;
import net.minecraft.client.render.blockentity.BlockEntityRenderer;
import net.minecraft.client.render.model.FlagModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.world.World;
import net.minecraft.core.world.wind.WindProvider;
import org.lwjgl.opengl.GL11;

public class FlagBlockEntityRenderer
extends BlockEntityRenderer<FlagBlockEntity> {
    public final Minecraft mc = Minecraft.getMinecraft(this);
    private final FlagModel flagModel = new FlagModel();
    private FlagRenderer flagRenderer = null;

    @Override
    public void doRender(Tessellator tessellator, FlagBlockEntity tileEntity, double x, double y, double z, float partialTick) {
        World theWorld = Minecraft.getMinecraft((Object)this).theWorld;
        int blockUnder = theWorld.getBlockId(tileEntity.x, tileEntity.y - 1, tileEntity.z);
        boolean shortPole = blockUnder == Blocks.FLAG.id;
        WindProvider theWind = this.mc.theWorld.getWorldType().getWindManager();
        float windDirection = theWind.getWindDirection(this.mc.theWorld, 0.0f, 500.0f, 0.0f) * 360.0f;
        float windIntensity = theWind.getWindIntensity(this.mc.theWorld, 0.0f, 500.0f, 0.0f);
        this.doRender(tileEntity, x, y, z, partialTick, shortPole, windDirection, windIntensity);
    }

    public void doRender(FlagBlockEntity tileEntity, double x, double y, double z, float partialTick, boolean shortPole, float windDirection, float windIntensity) {
        if (this.flagRenderer == null) {
            this.flagRenderer = new FlagRenderer(this.renderDispatcher.textureManager);
        }
        this.flagRenderer.updateTexture(tileEntity);
        float swayInterpolated = (float)tileEntity.sway + partialTick;
        float sway = (float)((double)swayInterpolated / 1.5 % (Math.PI * 2));
        sway = (float)(Math.sin(sway) * (double)windIntensity * 2.0);
        GL11.glPushMatrix();
        float scale = 1.0f;
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        this.loadTexture("/assets/minecraft/textures/entity/flag.png");
        if (shortPole) {
            this.flagModel.renderPoleShort();
        } else {
            this.flagModel.renderBase();
            this.flagModel.renderPole();
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)(windDirection + sway), (float)0.0f, (float)1.0f, (float)0.0f);
        this.flagModel.renderFlag();
        this.renderDispatcher.textureManager.bindTexture(this.flagRenderer.getTexture());
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)769, (int)768);
        this.flagModel.renderFlagOverlay();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        float f4 = 0.01666667f;
        GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.07f);
        GL11.glScalef((float)0.01666667f, (float)-0.01666667f, (float)0.01666667f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-0.01666667f);
        GL11.glPopMatrix();
    }
}

