/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import net.minecraft.client.render.item.model.StandardItemModel;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DyeColor;
import org.jetbrains.annotations.NotNull;

public class DoorPaintedItemModel
extends StandardItemModel {
    public static IconCoordinate[] doorIcons = new IconCoordinate[16];

    public DoorPaintedItemModel(Item item) {
        super(item, null);
    }

    @Override
    @NotNull
    public IconCoordinate getIcon(Entity entity, ItemStack itemStack) {
        int meta = itemStack.getMetadata();
        return doorIcons[meta & 0xF];
    }

    static {
        for (DyeColor c : DyeColor.itemOrderedColors()) {
            DoorPaintedItemModel.doorIcons[c.itemMeta] = TextureRegistry.getTexture("minecraft:item/door_" + c.colorID);
        }
    }
}

