/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class StandardItemModel
extends ItemModel {
    final Minecraft mc = Minecraft.getMinecraft(Minecraft.class);
    public static final IconCoordinate ITEM_TEXTURE_MISSING = TextureRegistry.getTexture("minecraft:item/texture_missing");
    public static final IconCoordinate ITEM_TEXTURE_UNASSIGNED = TextureRegistry.getTexture("minecraft:item/texture_unassigned");
    protected boolean useColor = true;
    public IconCoordinate icon = ITEM_TEXTURE_UNASSIGNED;
    protected boolean bFull3D = false;
    protected boolean rotateWhenRendering = false;
    protected boolean pointInfrontOfPlayer = false;
    protected boolean itemfullBright = false;

    public StandardItemModel(Item item, String namespace) {
        super(item);
        if (namespace != null) {
            this.icon = TextureRegistry.getTexture(namespace + ":item/" + item.getKey().substring("item.".length()).replace(".", "_"));
        }
    }

    @Override
    public void renderItemFirstPerson(Tessellator tessellator, ItemRenderer renderer, Player player, ItemStack stack, float partialTick) {
        float brightness = 1.0f;
        if (this.mc.fullbright || this.itemfullBright || LightmapHelper.isLightmapEnabled()) {
            if (LightmapHelper.isLightmapEnabled()) {
                int lightmapCoord = player.getLightmapCoord(partialTick);
                if (this.itemfullBright) {
                    lightmapCoord = LightmapHelper.setBlocklightValue(lightmapCoord, 15);
                }
                LightmapHelper.setLightmapCoord(lightmapCoord);
            }
        } else {
            brightness = player.getBrightness(1.0f);
        }
        float distanceScale = 0.8f;
        float swingProgress = player.getSwingProgress(partialTick);
        float animationProgress2 = MathHelper.sin(swingProgress * (float)Math.PI);
        float animationProgress = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI);
        GL11.glTranslatef((float)(-animationProgress * 0.4f), (float)(MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI * 2.0f) * 0.2f), (float)(-animationProgress2 * 0.2f));
        GL11.glTranslatef((float)0.56f, (float)(-0.52f - (1.0f - renderer.getEquippedProgress(partialTick)) * 0.6f), (float)-0.71999997f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)32826);
        float animationProgress3 = MathHelper.sin(swingProgress * swingProgress * (float)Math.PI);
        GL11.glRotatef((float)(-animationProgress3 * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-animationProgress * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(-animationProgress * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float scale = 0.4f;
        GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
        this.heldTransformFirstPerson(renderer, player, stack);
        this.renderItem(tessellator, renderer, stack, player, brightness, true);
    }

    @Override
    public void renderItem(Tessellator tessellator, ItemRenderer renderer, ItemStack itemstack, @Nullable Entity entity, float brightness, boolean handheldTransform) {
        if (this.itemfullBright || LightmapHelper.isLightmapEnabled()) {
            brightness = 1.0f;
        }
        if (handheldTransform) {
            GL11.glTranslatef((float)-0.0f, (float)-0.3f, (float)0.0f);
            float handheldScale = 1.5f;
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
        }
        this.renderItemInWorld(tessellator, entity, itemstack, brightness, 1.0f, false);
    }

    @Override
    public void renderItemThirdPerson(Tessellator tessellator, ItemRenderer renderer, Entity entity, ItemStack itemstack, boolean handheldTransform) {
        float brightness = 1.0f;
        if (this.mc.fullbright || this.itemfullBright || LightmapHelper.isLightmapEnabled()) {
            if (LightmapHelper.isLightmapEnabled()) {
                int lightmapCoord = entity.getLightmapCoord(1.0f);
                if (this.itemfullBright) {
                    lightmapCoord = LightmapHelper.getLightmapCoord(15, 15);
                }
                LightmapHelper.setLightmapCoord(lightmapCoord);
            }
        } else {
            brightness = entity.getBrightness(1.0f);
        }
        GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
        this.heldTransformThirdPerson(renderer, entity, itemstack);
        this.renderItem(tessellator, renderer, itemstack, entity, brightness, handheldTransform);
    }

    @Override
    public void renderItemIntoGui(Tessellator tessellator, Font font, TextureManager textureManager, ItemStack itemStack, int x, int y, float brightness, float alpha) {
        if (itemStack == null) {
            return;
        }
        Minecraft mc = Minecraft.getMinecraft(this);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2884);
        IconCoordinate textureIndex = this.getIcon(mc.thePlayer, itemStack);
        GL11.glDisable((int)2896);
        textureIndex.parentAtlas.bind();
        if (this.useColor) {
            int color = this.getColor(itemStack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
        } else {
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        }
        this.renderTexturedQuad(tessellator, x, y, textureIndex);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    @Override
    public void renderItemOverlayIntoGUI(Tessellator tessellator, Font font, TextureManager textureManager, ItemStack itemstack, int x, int y, String override, float alpha) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (itemstack == null) {
            return;
        }
        int a = (int)(alpha * 255.0f);
        if (itemstack.stackSize != 1 || override != null) {
            String s = override != null ? override : "" + itemstack.stackSize;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            font.drawStringWithShadow(s, x + 19 - 2 - font.getStringWidth(s), y + 6 + 3, 0xFFFFFF | a << 24);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        if (itemstack.isItemDamaged() || itemstack.getItem().showFullDurability()) {
            int barWidth = (int)Math.round(13.0 - (double)itemstack.getItemDamageForDisplay() * 13.0 / (double)itemstack.getMaxDamage());
            int progress = (int)Math.round(255.0 - (double)itemstack.getItemDamageForDisplay() * 255.0 / (double)itemstack.getMaxDamage());
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            int colorFG = Color.HSBtoRGB((float)progress / 255.0f / 3.0f, 1.0f, 1.0f);
            int colorBG = (255 - progress) / 4 << 16 | 0x3F00;
            this.renderColoredQuad(tessellator, x + 2, y + 13, 13, 2, 0, a);
            this.renderColoredQuad(tessellator, x + 2, y + 13, 12, 1, colorBG, a);
            this.renderColoredQuad(tessellator, x + 2, y + 13, barWidth, 1, colorFG, a);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glDisable((int)3042);
    }

    @Override
    public void renderAsItemEntity(Tessellator tessellator, @Nullable Entity entity, Random random, ItemStack itemstack, int renderCount, float yaw, float brightness, float partialTick) {
        int i;
        Minecraft mc = Minecraft.getMinecraft(this);
        if (mc.fullbright || this.itemfullBright) {
            brightness = 1.0f;
        }
        EntityRenderDispatcher renderDispatcher = EntityRenderDispatcher.instance;
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        IconCoordinate tex = this.getIcon(entity, itemstack);
        tex.parentAtlas.bind();
        if (this.useColor) {
            int color = this.getColor(itemstack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)1.0f);
        } else {
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        }
        if (LightmapHelper.isLightmapEnabled() && this.itemfullBright && entity != null) {
            int lmc = entity.getLightmapCoord(1.0f);
            lmc = LightmapHelper.setBlocklightValue(lmc, 15);
            LightmapHelper.setLightmapCoord(lmc);
        }
        if (((Boolean)mc.gameSettings.items3D.value).booleanValue()) {
            GL11.glPushMatrix();
            GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
            GL11.glRotated((double)yaw, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)0.0, (double)(-0.05 * (double)(renderCount - 1)));
            for (i = 0; i < renderCount; ++i) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)0.0, (double)(0.1 * (double)i));
                this.renderItem(tessellator, renderDispatcher.itemRenderer, itemstack, entity, brightness, false);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        } else {
            for (i = 0; i < renderCount; ++i) {
                GL11.glPushMatrix();
                if (i > 0) {
                    float rOffX = (random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float rOffY = (random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float rOffZ = (random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    GL11.glTranslatef((float)rOffX, (float)rOffY, (float)rOffZ);
                }
                GL11.glRotatef((float)(180.0f - renderDispatcher.viewLerpYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderFlat(tessellator, tex);
                GL11.glPopMatrix();
            }
        }
    }

    @Override
    public void renderItemInWorld(Tessellator tessellator, Entity entity, ItemStack itemStack, float brightness, float alpha, boolean worldTransform) {
        float y;
        float v;
        float x;
        float u;
        float texProgress;
        int i;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.useColor) {
            int color = this.getColor(itemStack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
        } else {
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        }
        IconCoordinate tex = this.getIcon(entity, itemStack);
        tex.parentAtlas.bind();
        int tileWidth = tex.width;
        float uMin = (float)tex.getIconUMin();
        float uMax = (float)tex.getIconUMax();
        float vMin = (float)tex.getIconVMin();
        float vMax = (float)tex.getIconVMax();
        float uDiff = uMin - uMax;
        float vDiff = vMin - vMax;
        float width = 1.0f;
        float foon = 9.765625E-4f;
        float goon = 0.0625f * (16.0f / (float)tileWidth);
        GL11.glEnable((int)32826);
        float thickness = 0.0625f;
        float pixelWidth = 1.0f / (float)tileWidth;
        if (worldTransform) {
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.03125f);
        }
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, uMax, vMax);
        tessellator.addVertexWithUV(1.0, 0.0, 0.0, uMin, vMax);
        tessellator.addVertexWithUV(1.0, 1.0, 0.0, uMin, vMin);
        tessellator.addVertexWithUV(0.0, 1.0, 0.0, uMax, vMin);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        tessellator.addVertexWithUV(0.0, 1.0, -0.0625, uMax, vMin);
        tessellator.addVertexWithUV(1.0, 1.0, -0.0625, uMin, vMin);
        tessellator.addVertexWithUV(1.0, 0.0, -0.0625, uMin, vMax);
        tessellator.addVertexWithUV(0.0, 0.0, -0.0625, uMax, vMax);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            u = uMax + uDiff * texProgress - 9.765625E-4f;
            x = 1.0f * texProgress;
            tessellator.addVertexWithUV(x, 0.0, -0.0625, u, vMax);
            tessellator.addVertexWithUV(x, 0.0, 0.0, u, vMax);
            tessellator.addVertexWithUV(x, 1.0, 0.0, u, vMin);
            tessellator.addVertexWithUV(x, 1.0, -0.0625, u, vMin);
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            u = uMax + uDiff * texProgress - 9.765625E-4f;
            x = 1.0f * texProgress + goon;
            tessellator.addVertexWithUV(x, 1.0, -0.0625, u, vMin);
            tessellator.addVertexWithUV(x, 1.0, 0.0, u, vMin);
            tessellator.addVertexWithUV(x, 0.0, 0.0, u, vMax);
            tessellator.addVertexWithUV(x, 0.0, -0.0625, u, vMax);
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            v = vMax + vDiff * texProgress - 9.765625E-4f;
            y = 1.0f * texProgress + goon;
            tessellator.addVertexWithUV(0.0, y, 0.0, uMax, v);
            tessellator.addVertexWithUV(1.0, y, 0.0, uMin, v);
            tessellator.addVertexWithUV(1.0, y, -0.0625, uMin, v);
            tessellator.addVertexWithUV(0.0, y, -0.0625, uMax, v);
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            v = vMax + vDiff * texProgress - 9.765625E-4f;
            y = 1.0f * texProgress;
            tessellator.addVertexWithUV(1.0, y, 0.0, uMin, v);
            tessellator.addVertexWithUV(0.0, y, 0.0, uMax, v);
            tessellator.addVertexWithUV(0.0, y, -0.0625, uMax, v);
            tessellator.addVertexWithUV(1.0, y, -0.0625, uMin, v);
        }
        tessellator.draw();
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
    }

    public void renderFlat(Tessellator tessellator, IconCoordinate index) {
        float xOff = 0.5f;
        float yOff = 0.25f;
        float z = 0.0f;
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        tessellator.addVertexWithUV(-0.5, -0.25, 0.0, index.getIconUMin(), index.getIconVMax());
        tessellator.addVertexWithUV(0.5, -0.25, 0.0, index.getIconUMax(), index.getIconVMax());
        tessellator.addVertexWithUV(0.5, 0.75, 0.0, index.getIconUMax(), index.getIconVMin());
        tessellator.addVertexWithUV(-0.5, 0.75, 0.0, index.getIconUMin(), index.getIconVMin());
        tessellator.draw();
    }

    public void heldTransformThirdPerson(ItemRenderer renderer, Entity entity, ItemStack itemStack) {
        if (this.bFull3D) {
            float scale = 0.625f;
            if (this.rotateWhenRendering) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
            }
            if (this.pointInfrontOfPlayer) {
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
            GL11.glScalef((float)0.625f, (float)-0.625f, (float)0.625f);
            GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            float scale = 0.375f;
            GL11.glTranslatef((float)0.25f, (float)0.1875f, (float)-0.1875f);
            GL11.glScalef((float)0.375f, (float)0.375f, (float)0.375f);
            GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    public void heldTransformFirstPerson(ItemRenderer renderer, Entity entity, ItemStack itemStack) {
        if (this.rotateWhenRendering) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.pointInfrontOfPlayer) {
            GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    @Override
    @NotNull
    public IconCoordinate getIcon(@Nullable Entity entity, ItemStack itemStack) {
        return this.icon;
    }

    public int getColor(ItemStack stack) {
        return this.getColorFromMeta(stack.getMetadata());
    }

    public int getColorFromMeta(int meta) {
        return 0xFFFFFF;
    }

    protected void renderColoredQuad(Tessellator tessellator, int x, int y, int width, int height, int colorRGB, int alpha) {
        float z = 0.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(colorRGB, alpha);
        tessellator.addVertex(x, y, 0.0);
        tessellator.addVertex(x, y + height, 0.0);
        tessellator.addVertex(x + width, y + height, 0.0);
        tessellator.addVertex(x + width, y, 0.0);
        tessellator.draw();
    }

    protected void renderTexturedQuad(Tessellator tessellator, int x, int y, IconCoordinate icon) {
        this.renderTexturedQuad(tessellator, x, y, icon, false, false);
    }

    protected void renderTexturedQuad(Tessellator tessellator, int x, int y, IconCoordinate icon, boolean flipX, boolean flipY) {
        float z = 0.0f;
        double uMin = icon.getIconUMin();
        double uMax = icon.getIconUMax();
        double vMin = icon.getIconVMin();
        double vMax = icon.getIconVMax();
        if (flipX) {
            double _uMin = uMin;
            uMin = uMax;
            uMax = _uMin;
        }
        if (flipY) {
            double _vMin = vMin;
            vMin = vMax;
            vMax = _vMin;
        }
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x, y + 16, 0.0, uMin, vMax);
        tessellator.addVertexWithUV(x + 16, y + 16, 0.0, uMax, vMax);
        tessellator.addVertexWithUV(x + 16, y, 0.0, uMax, vMin);
        tessellator.addVertexWithUV(x, y, 0.0, uMin, vMin);
        tessellator.draw();
    }

    public StandardItemModel setFull3D() {
        this.bFull3D = true;
        return this;
    }

    public StandardItemModel setRotateWhenRendering() {
        this.rotateWhenRendering = true;
        return this;
    }

    public StandardItemModel setPointInfrontOfPlayer() {
        this.pointInfrontOfPlayer = true;
        return this;
    }

    public StandardItemModel setFullBright() {
        this.itemfullBright = true;
        return this;
    }
}

