/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.net.handler.ClientPacketHandler;
import net.minecraft.client.world.chunk.provider.ChunkProviderClient;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.packet.DisconnectPacket;
import net.minecraft.core.util.collection.IntHashMap;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.save.SaveHandlerClientMP;

public class WorldClient
extends World {
    private final Minecraft mc;
    private final LinkedList<WorldBlockPositionType> positionTypesList;
    private final ClientPacketHandler sendQueue;
    private ChunkProviderClient chunkCache;
    private final IntHashMap<Entity> entitiesById;
    private final Set<Entity> forced;
    private final Set<Entity> reEntries;

    public WorldClient(Minecraft minecraft, ClientPacketHandler netclienthandler, long seed, int dimensionId, int worldTypeId) {
        super(new SaveHandlerClientMP(), "MpServer", Dimension.getDimensionList().get(dimensionId), Registries.WORLD_TYPES.getItemByNumericId(worldTypeId), seed);
        this.mc = minecraft;
        this.positionTypesList = new LinkedList();
        this.entitiesById = new IntHashMap();
        this.forced = new HashSet<Entity>();
        this.reEntries = new HashSet<Entity>();
        this.sendQueue = netclienthandler;
        this.setSpawnPoint(new ChunkCoordinates(8, 64, 8));
        this.savedDataStorage = netclienthandler.savedDataStorage;
    }

    @Override
    public void tick() {
        for (int k = 0; k < 10 && !this.reEntries.isEmpty(); ++k) {
            Entity entity = this.reEntries.iterator().next();
            if (this.loadedEntityList.contains(entity)) continue;
            this.entityJoinedWorld(entity);
        }
        this.processPackets();
        for (int l = 0; l < this.positionTypesList.size(); ++l) {
            WorldBlockPositionType worldblockpositiontype = this.positionTypesList.get(l);
            if (--worldblockpositiontype.delayTicks != 0) continue;
            super.setBlockAndMetadata(worldblockpositiontype.x, worldblockpositiontype.y, worldblockpositiontype.z, worldblockpositiontype.blockId, worldblockpositiontype.metadata);
            super.markBlockNeedsUpdate(worldblockpositiontype.x, worldblockpositiontype.y, worldblockpositiontype.z);
            this.positionTypesList.remove(l--);
        }
        this.updateSeasonAndLight();
        if (this.rainbowTicks > 0) {
            --this.rainbowTicks;
        }
    }

    public void processPackets() {
        this.sendQueue.tick();
    }

    public void func_711_c(int i, int j, int k, int l, int i1, int j1) {
        for (int k1 = 0; k1 < this.positionTypesList.size(); ++k1) {
            WorldBlockPositionType worldblockpositiontype = this.positionTypesList.get(k1);
            if (worldblockpositiontype.x < i || worldblockpositiontype.y < j || worldblockpositiontype.z < k || worldblockpositiontype.x > l || worldblockpositiontype.y > i1 || worldblockpositiontype.z > j1) continue;
            this.positionTypesList.remove(k1--);
        }
    }

    @Override
    protected IChunkProvider createChunkProvider() {
        this.chunkCache = new ChunkProviderClient(this);
        return this.chunkCache;
    }

    @Override
    public void getRespawnLocation() {
        this.setSpawnPoint(new ChunkCoordinates(8, 64, 8));
    }

    @Override
    protected void updateBlocksAndPlayCaveSounds() {
    }

    @Override
    public void scheduleBlockUpdate(int i, int j, int k, int l, int i1) {
    }

    @Override
    public boolean tickUpdates(boolean flag) {
        return false;
    }

    public void doPreChunk(int i, int j, boolean flag) {
        if (flag) {
            this.chunkCache.prepareChunk(i, j);
        } else {
            this.chunkCache.func_539_c(i, j);
        }
        if (!flag) {
            this.markBlocksDirty(i * 16, 0, j * 16, i * 16 + 15, this.getHeightBlocks(), j * 16 + 15);
        }
    }

    @Override
    public boolean entityJoinedWorld(Entity entity) {
        boolean flag = super.entityJoinedWorld(entity);
        this.forced.add(entity);
        if (!flag) {
            this.reEntries.add(entity);
        }
        return flag;
    }

    @Override
    public void setEntityDead(Entity entity) {
        super.setEntityDead(entity);
        this.forced.remove(entity);
    }

    @Override
    protected void obtainEntitySkin(Entity entity) {
        super.obtainEntitySkin(entity);
        this.reEntries.remove(entity);
    }

    @Override
    protected void releaseEntitySkin(Entity entity) {
        super.releaseEntitySkin(entity);
        if (this.forced.contains(entity)) {
            this.reEntries.add(entity);
        }
    }

    public void addEntityToWorld(int i, Entity entity) {
        Entity entity1 = this.getEntityFromId(i);
        if (entity1 != null) {
            this.setEntityDead(entity1);
        }
        this.forced.add(entity);
        entity.id = i;
        if (!this.entityJoinedWorld(entity)) {
            this.reEntries.add(entity);
        }
        this.entitiesById.put(i, entity);
    }

    public Entity getEntityFromId(int i) {
        return this.entitiesById.get(i);
    }

    public Entity removeEntityFromWorld(int i) {
        Entity entity = this.entitiesById.remove(i);
        if (entity != null) {
            this.forced.remove(entity);
            this.setEntityDead(entity);
        }
        return entity;
    }

    @Override
    public boolean setBlockMetadata(int x, int y, int z, int meta) {
        int blockID = this.getBlockId(x, y, z);
        int currentMeta = this.getBlockMetadata(x, y, z);
        if (super.setBlockMetadata(x, y, z, meta)) {
            this.positionTypesList.add(new WorldBlockPositionType(x, y, z, blockID, currentMeta));
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlockAndMetadata(int x, int y, int z, int id, int meta) {
        int blockId = this.getBlockId(x, y, z);
        int blockMeta = this.getBlockMetadata(x, y, z);
        if (super.setBlockAndMetadata(x, y, z, id, meta)) {
            this.positionTypesList.add(new WorldBlockPositionType(x, y, z, blockId, blockMeta));
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlock(int x, int y, int z, int id) {
        int blockId = this.getBlockId(x, y, z);
        int meta = this.getBlockMetadata(x, y, z);
        if (super.setBlock(x, y, z, id)) {
            this.positionTypesList.add(new WorldBlockPositionType(x, y, z, blockId, meta));
            return true;
        }
        return false;
    }

    public boolean blockChange(int x, int y, int z, int id, int meta) {
        this.func_711_c(x, y, z, x, y, z);
        if (super.setBlockAndMetadata(x, y, z, id, meta)) {
            this.notifyBlockChange(x, y, z, id);
            return true;
        }
        return false;
    }

    @Override
    public void sendQuittingDisconnectingPacket() {
        this.sendQueue.func_28117_a(new DisconnectPacket("Quitting"));
    }

    @Override
    public void sendGlobalMessage(String message) {
    }

    static class WorldBlockPositionType {
        int x;
        int y;
        int z;
        int delayTicks;
        int blockId;
        int metadata;

        public WorldBlockPositionType(int x, int y, int z, int blockId, int metadata) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.delayTicks = 80;
            this.blockId = blockId;
            this.metadata = metadata;
        }
    }
}

