/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.FarmlandBlock;
import net.minecraft.core.block.FlowerBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class CropsWheatBlock
extends FlowerBlock
implements IBonemealable {
    public CropsWheatBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id);
        this.setTicking(true);
        float f = 0.5f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, 0.25, 0.5f + f);
    }

    @Override
    public boolean canThisPlantGrowOnThisBlockID(int i) {
        return i == Blocks.FARMLAND_DIRT.id;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        float f;
        int l;
        super.updateTick(world, x, y, z, rand);
        if (world.getBlockLightValue(x, y + 1, z) >= 9 && (l = world.getBlockMetadata(x, y, z)) < 7 && rand.nextInt((int)(100.0f / (f = this.getGrowthRate(world, x, y, z)))) == 0) {
            world.setBlockMetadataWithNotify(x, y, z, ++l);
        }
    }

    public void fertilize(World world, int i, int j, int k) {
        world.setBlockMetadataWithNotify(i, j, k, 7);
    }

    private float getGrowthRate(World world, int x, int y, int z) {
        boolean isFertilized;
        float growthRate = 1.0f;
        int idNegZ = world.getBlockId(x, y, z - 1);
        int idPosZ = world.getBlockId(x, y, z + 1);
        int idNegX = world.getBlockId(x - 1, y, z);
        int idPosX = world.getBlockId(x + 1, y, z);
        int idNegXNegZ = world.getBlockId(x - 1, y, z - 1);
        int idPosXNegZ = world.getBlockId(x + 1, y, z - 1);
        int idPosXPosZ = world.getBlockId(x + 1, y, z + 1);
        int idNegXPosZ = world.getBlockId(x - 1, y, z + 1);
        boolean xNeighbor = idNegX == this.id || idPosX == this.id;
        boolean zNeighbor = idNegZ == this.id || idPosZ == this.id;
        boolean diagNeighbor = idNegXNegZ == this.id || idPosXNegZ == this.id || idPosXPosZ == this.id || idNegXPosZ == this.id;
        for (int dx = x - 1; dx <= x + 1; ++dx) {
            for (int dz = z - 1; dz <= z + 1; ++dz) {
                int id = world.getBlockId(dx, y - 1, dz);
                float growthRateMod = 0.0f;
                if (id == Blocks.FARMLAND_DIRT.id) {
                    growthRateMod = 1.0f;
                    if (world.getBlockMetadata(dx, y - 1, dz) > 0) {
                        growthRateMod = 3.0f;
                    }
                }
                if (dx != x || dz != z) {
                    growthRateMod /= 4.0f;
                }
                growthRate += growthRateMod;
            }
        }
        if (diagNeighbor || xNeighbor && zNeighbor) {
            growthRate /= 2.0f;
        }
        if (!(isFertilized = FarmlandBlock.isFertilized(world.getBlockMetadata(x, y - 1, z)))) {
            if (world.getSeasonManager().getCurrentSeason() != null) {
                growthRate *= world.getSeasonManager().getCurrentSeason().cropGrowthFactor;
            }
        } else {
            growthRate *= 1.5f;
        }
        return growthRate;
    }

    @Override
    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, Side side, int meta, Player player, Item item) {
        boolean isFertilized = FarmlandBlock.isFertilized(world.getBlockMetadata(x, y - 1, z));
        if (isFertilized && !world.isClientSide) {
            boolean shouldDefertilize;
            boolean bl = shouldDefertilize = world.rand.nextInt(3) == 2;
            if (shouldDefertilize) {
                world.setBlockMetadata(x, y - 1, z, FarmlandBlock.setFertilized(world.getBlockMetadata(x, y - 1, z), false));
            }
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        if (meta != 7) {
            return new ItemStack[]{new ItemStack(Items.SEEDS_WHEAT)};
        }
        return new ItemStack[]{new ItemStack(Items.SEEDS_WHEAT, world.rand.nextInt(3) + 1), new ItemStack(Items.WHEAT)};
    }

    @Override
    public boolean onBonemealUsed(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (world.getBlockMetadata(blockX, blockY, blockZ) < 7) {
            if (!world.isClientSide) {
                ((CropsWheatBlock)Blocks.CROPS_WHEAT).fertilize(world, blockX, blockY, blockZ);
                if (entityplayer.getGamemode().consumeBlocks()) {
                    --itemstack.stackSize;
                }
            }
            return true;
        }
        return false;
    }
}

