/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.RotatableEntityBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.DispenserBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ArrowProjectile;
import net.minecraft.core.entity.projectile.CannonballProjectile;
import net.minecraft.core.entity.projectile.GoldenArrowProjectile;
import net.minecraft.core.item.IDispensable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class DispenserBlock
extends RotatableEntityBlock {
    private Random random = new Random();

    public DispenserBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.stone);
    }

    @Override
    public int tickDelay() {
        return 4;
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        super.onBlockPlacedByWorld(world, x, y, z);
        this.recalculateLookDirection(world, x, y, z);
    }

    private void recalculateLookDirection(World world, int x, int y, int z) {
        if (world.isClientSide) {
            return;
        }
        int l = world.getBlockId(x, y, z - 1);
        int i1 = world.getBlockId(x, y, z + 1);
        int j1 = world.getBlockId(x - 1, y, z);
        int k1 = world.getBlockId(x + 1, y, z);
        int byte0 = 3;
        if (Block.solid[l] && !Block.solid[i1]) {
            byte0 = 3;
        }
        if (Block.solid[i1] && !Block.solid[l]) {
            byte0 = 2;
        }
        if (Block.solid[j1] && !Block.solid[k1]) {
            byte0 = 5;
        }
        if (Block.solid[k1] && !Block.solid[j1]) {
            byte0 = 4;
        }
        world.setBlockMetadataWithNotify(x, y, z, byte0);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (world.isClientSide) {
            return true;
        }
        DispenserBlockEntity tileentitydispenser = (DispenserBlockEntity)world.getBlockEntity(x, y, z);
        player.displayDispenserScreen(tileentitydispenser);
        return true;
    }

    private void dispenseItem(World world, int x, int y, int z, Random random) {
        int data = world.getBlockMetadata(x, y, z);
        int xOffset = 0;
        int zOffset = 0;
        if (data == 3) {
            zOffset = 1;
        } else if (data == 2) {
            zOffset = -1;
        } else {
            xOffset = data == 5 ? 1 : -1;
        }
        DispenserBlockEntity tileEntity = (DispenserBlockEntity)world.getBlockEntity(x, y, z);
        ItemStack itemStack = tileEntity.getRandomStackFromInventory();
        double px = (double)x + (double)xOffset * 0.6 + 0.5;
        double py = (double)y + 0.5;
        double pz = (double)z + (double)zOffset * 0.6 + 0.5;
        if (itemStack == null) {
            world.playSoundEffect(1001, x, y, z, 0);
        } else {
            if (itemStack.getItem() instanceof IDispensable) {
                IDispensable dispensable = (IDispensable)((Object)itemStack.getItem());
                dispensable.onDispensed(itemStack, world, px, py, pz, xOffset, zOffset, random);
                world.playSoundEffect(1002, x, y, z, 0);
            } else if (itemStack.itemID == Items.AMMO_ARROW.id || itemStack.itemID == Items.AMMO_ARROW_GOLD.id) {
                ArrowProjectile arrow = itemStack.itemID == Items.AMMO_ARROW.id ? new ArrowProjectile(world, px, py, pz, 0) : new GoldenArrowProjectile(world, px, py, pz);
                arrow.setHeading(xOffset, 0.1, zOffset, 1.1f, 6.0f);
                arrow.setDoesArrowBelongToPlayer(true);
                world.entityJoinedWorld(arrow);
                world.playSoundEffect(1002, x, y, z, 0);
            } else if (itemStack.itemID == Items.AMMO_CHARGE_EXPLOSIVE.id) {
                CannonballProjectile cannonballProjectile = new CannonballProjectile(world, px, py, pz);
                cannonballProjectile.setHeading(xOffset, 0.1, zOffset, 1.1f, 6.0f);
                world.entityJoinedWorld(cannonballProjectile);
                world.playSoundEffect(1002, x, y, z, 0);
            } else {
                ItemEntity item = new ItemEntity(world, px, py - 0.3, pz, itemStack);
                double randOffset = random.nextDouble() * 0.1 + 0.2;
                item.xd = (double)xOffset * randOffset;
                item.yd = 0.2;
                item.zd = (double)zOffset * randOffset;
                item.xd += random.nextGaussian() * 0.0075 * 6.0;
                item.yd += random.nextGaussian() * 0.0075 * 6.0;
                item.zd += random.nextGaussian() * 0.0075 * 6.0;
                world.entityJoinedWorld(item);
                world.playSoundEffect(1000, x, y, z, 0);
            }
            world.playSoundEffect(2000, x, y, z, xOffset + 1 + (zOffset + 1) * 3);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (blockId > 0 && Block.blocksList[blockId].isSignalSource()) {
            boolean flag;
            boolean bl = flag = world.isBlockIndirectlyGettingPowered(x, y, z) || world.isBlockIndirectlyGettingPowered(x, y + 1, z);
            if (flag) {
                world.scheduleBlockUpdate(x, y, z, this.id, this.tickDelay());
            }
        }
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isBlockIndirectlyGettingPowered(x, y, z) || world.isBlockIndirectlyGettingPowered(x, y + 1, z)) {
            this.dispenseItem(world, x, y, z, rand);
        }
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return new DispenserBlockEntity();
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (world.getBlockEntity(x, y, z) != null) {
            DispenserBlockEntity tileentitydispenser = (DispenserBlockEntity)world.getBlockEntity(x, y, z);
            for (int l = 0; l < tileentitydispenser.getContainerSize(); ++l) {
                ItemStack itemstack = tileentitydispenser.getItem(l);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.random.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    ItemEntity entityitem = new ItemEntity(world, (float)x + f, (float)y + f1, (float)z + f2, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.xd = (float)this.random.nextGaussian() * f3;
                    entityitem.yd = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.zd = (float)this.random.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoved(world, x, y, z, data);
    }
}

