/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.RotatableBlock;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tool.SwordToolItem;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class PumpkinBlock
extends RotatableBlock {
    private final boolean isCarvable;

    public PumpkinBlock(String key, String namespaceId, int id, boolean isCarvable) {
        super(key, namespaceId, id, Material.vegetable);
        this.setTicking(true);
        this.isCarvable = isCarvable;
        this.withOverrideColor(MaterialColor.paintedOrange);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (!this.isCarvable) {
            return false;
        }
        ItemStack heldItem = player.getHeldItem();
        if (heldItem != null && heldItem.getItem() instanceof SwordToolItem) {
            heldItem.damageItem(1, player);
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.PUMPKIN_CARVED_IDLE.id, player.getHorizontalPlacementDirection(Direction.getHorizontalDirection(player).getSide()).getOpposite().getId());
            return true;
        }
        return false;
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
    }
}

