/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class RepeaterBlock
extends Block {
    public static final double[] torchPosOffset = new double[]{-0.0625, 0.0625, 0.1875, 0.3125};
    private static final int[] tickDelayMap = new int[]{1, 2, 3, 4};
    public final boolean isRepeaterPowered;

    public RepeaterBlock(String key, String namespaceId, int id, boolean flag) {
        super(key, namespaceId, id, Material.decoration);
        this.isRepeaterPowered = flag;
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (!world.canPlaceOnSurfaceOfBlock(x, y - 1, z)) {
            return false;
        }
        return super.canPlaceBlockAt(world, x, y, z);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        return new ItemStack[]{new ItemStack(Items.REPEATER)};
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        if (!world.canPlaceOnSurfaceOfBlock(x, y - 1, z)) {
            return false;
        }
        return super.canBlockStay(world, x, y, z);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        int meta = world.getBlockMetadata(x, y, z);
        boolean flag = this.func_22022_g(world, x, y, z, meta);
        if (this.isRepeaterPowered && !flag) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.REPEATER_IDLE.id, meta);
        } else if (!this.isRepeaterPowered) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.REPEATER_ACTIVE.id, meta);
            if (!flag) {
                int i1 = (meta & 0xC) >> 2;
                world.scheduleBlockUpdate(x, y, z, Blocks.REPEATER_ACTIVE.id, tickDelayMap[i1] * 2);
            }
        }
    }

    @Override
    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        return this.getSignal(world, x, y, z, side);
    }

    @Override
    public boolean getSignal(WorldSource blockAccess, int x, int y, int z, Side side) {
        if (!this.isRepeaterPowered) {
            return false;
        }
        int meta = blockAccess.getBlockMetadata(x, y, z) & 3;
        if (meta == 0 && side == Side.SOUTH) {
            return true;
        }
        if (meta == 1 && side == Side.WEST) {
            return true;
        }
        if (meta == 2 && side == Side.NORTH) {
            return true;
        }
        return meta == 3 && side == Side.EAST;
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!this.canBlockStay(world, x, y, z)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null, null);
            world.setBlockWithNotify(x, y, z, 0);
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        boolean flag = this.func_22022_g(world, x, y, z, meta);
        int j1 = (meta & 0xC) >> 2;
        if (this.isRepeaterPowered && !flag) {
            world.scheduleBlockUpdate(x, y, z, this.id, tickDelayMap[j1] * 2);
        } else if (!this.isRepeaterPowered && flag) {
            world.scheduleBlockUpdate(x, y, z, this.id, tickDelayMap[j1] * 2);
        }
    }

    private boolean func_22022_g(World world, int x, int y, int z, int meta) {
        int direction = meta & 3;
        switch (direction) {
            case 0: {
                return world.isBlockIndirectlyProvidingPowerTo(x, y, z + 1, Side.SOUTH) || world.getBlockId(x, y, z + 1) == Blocks.WIRE_REDSTONE.id && world.getBlockMetadata(x, y, z + 1) > 0;
            }
            case 2: {
                return world.isBlockIndirectlyProvidingPowerTo(x, y, z - 1, Side.NORTH) || world.getBlockId(x, y, z - 1) == Blocks.WIRE_REDSTONE.id && world.getBlockMetadata(x, y, z - 1) > 0;
            }
            case 3: {
                return world.isBlockIndirectlyProvidingPowerTo(x + 1, y, z, Side.EAST) || world.getBlockId(x + 1, y, z) == Blocks.WIRE_REDSTONE.id && world.getBlockMetadata(x + 1, y, z) > 0;
            }
            case 1: {
                return world.isBlockIndirectlyProvidingPowerTo(x - 1, y, z, Side.WEST) || world.getBlockId(x - 1, y, z) == Blocks.WIRE_REDSTONE.id && world.getBlockMetadata(x - 1, y, z) > 0;
            }
        }
        return false;
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        int l = world.getBlockMetadata(x, y, z);
        int i1 = (l & 0xC) >> 2;
        i1 = i1 + 1 << 2 & 0xC;
        world.setBlockMetadataWithNotify(x, y, z, i1 | l & 3);
        return true;
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, Side side, Mob mob, double sideHeight) {
        int l = mob.getHorizontalPlacementDirection((Side)side).index;
        world.setBlockMetadataWithNotify(x, y, z, l);
        boolean flag = this.func_22022_g(world, x, y, z, l);
        if (flag) {
            world.scheduleBlockUpdate(x, y, z, this.id, 1);
        }
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
        world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
        world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
        world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
        world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
        world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        if (!this.isRepeaterPowered) {
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        double px = (double)x + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double py = (double)y + 0.4 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double pz = (double)z + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double xOffset = 0.0;
        double zOffset = 0.0;
        int redstoneBrightness = 15;
        Color color = Colors.allRedstoneColors[15];
        if (color == null) {
            return;
        }
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        if (rand.nextInt(2) == 0) {
            switch (meta & 3) {
                case 0: {
                    zOffset = -0.3125;
                    break;
                }
                case 2: {
                    zOffset = 0.3125;
                    break;
                }
                case 3: {
                    xOffset = -0.3125;
                    break;
                }
                case 1: {
                    xOffset = 0.3125;
                }
            }
        } else {
            int i1 = (meta & 0xC) >> 2;
            switch (meta & 3) {
                case 0: {
                    zOffset = torchPosOffset[i1];
                    break;
                }
                case 2: {
                    zOffset = -torchPosOffset[i1];
                    break;
                }
                case 3: {
                    xOffset = torchPosOffset[i1];
                    break;
                }
                case 1: {
                    xOffset = -torchPosOffset[i1];
                }
            }
        }
        world.spawnParticle("reddust", px + xOffset, py, pz + zOffset, red, green, blue, 15);
    }
}

