/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.logic.PistonDirections;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.piston.BasePistonBlock;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class PistonHeadBlock
extends Block {
    public PistonHeadBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.piston);
        this.withHardness(0.5f);
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        int i1;
        super.onBlockRemoved(world, x, y, z, data);
        int direction = PistonHeadBlock.getDirectionFromMeta(data);
        if (direction >= 6) {
            return;
        }
        int orientation = PistonDirections.directionMap[direction];
        int k1 = world.getBlockId(x += PistonDirections.xOffset[orientation], y += PistonDirections.yOffset[orientation], z += PistonDirections.zOffset[orientation]);
        if ((k1 == Blocks.PISTON_BASE.id || k1 == Blocks.PISTON_BASE_STICKY.id) && BasePistonBlock.isPowered(i1 = world.getBlockMetadata(x, y, z))) {
            Block.blocksList[k1].dropBlockWithCause(world, EnumDropCause.PROPER_TOOL, x, y, z, i1, null, null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, Side side) {
        return false;
    }

    @Override
    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AABB aabb, ArrayList<AABB> aabbList) {
        int l = world.getBlockMetadata(x, y, z);
        switch (PistonHeadBlock.getDirectionFromMeta(l)) {
            case 0: {
                this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(0.375, 0.25, 0.375, 0.625, 1.25, 0.625);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                break;
            }
            case 1: {
                this.setBlockBounds(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(0.375, -0.25, 0.375, 0.625, 0.75, 0.625);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                break;
            }
            case 2: {
                this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.25);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(0.25, 0.375, 0.25, 0.75, 0.625, 1.25);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                break;
            }
            case 3: {
                this.setBlockBounds(0.0, 0.0, 0.75, 1.0, 1.0, 1.0);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(0.25, 0.375, -0.25, 0.75, 0.625, 0.75);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                break;
            }
            case 4: {
                this.setBlockBounds(0.0, 0.0, 0.0, 0.25, 1.0, 1.0);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(0.25, 0.375, 0.25, 1.25, 0.625, 0.75);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                break;
            }
            case 5: {
                this.setBlockBounds(0.75, 0.0, 0.0, 1.0, 1.0, 1.0);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(-0.25, 0.375, 0.25, 0.75, 0.625, 0.75);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
            }
        }
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        switch (PistonHeadBlock.getDirectionFromMeta(l)) {
            case 0: {
                this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
                break;
            }
            case 1: {
                this.setBlockBounds(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
                break;
            }
            case 2: {
                this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.25);
                break;
            }
            case 3: {
                this.setBlockBounds(0.0, 0.0, 0.75, 1.0, 1.0, 1.0);
                break;
            }
            case 4: {
                this.setBlockBounds(0.0, 0.0, 0.0, 0.25, 1.0, 1.0);
                break;
            }
            case 5: {
                this.setBlockBounds(0.75, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        int direction = PistonHeadBlock.getDirectionFromMeta(world.getBlockMetadata(x, y, z));
        if (direction >= 6) {
            return;
        }
        int id = world.getBlockId(x - PistonDirections.xOffset[direction], y - PistonDirections.yOffset[direction], z - PistonDirections.zOffset[direction]);
        if (id != Blocks.PISTON_BASE.id && id != Blocks.PISTON_BASE_STICKY.id) {
            world.setBlockWithNotify(x, y, z, 0);
        } else {
            Block.blocksList[id].onNeighborBlockChange(world, x - PistonDirections.xOffset[direction], y - PistonDirections.yOffset[direction], z - PistonDirections.zOffset[direction], blockId);
        }
    }

    public static int getDirectionFromMeta(int meta) {
        return meta & 7;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        if (dropCause == EnumDropCause.PICK_BLOCK) {
            if ((meta & 8) != 0) {
                return new ItemStack[]{new ItemStack(Blocks.PISTON_BASE_STICKY)};
            }
            return new ItemStack[]{new ItemStack(Blocks.PISTON_BASE)};
        }
        return null;
    }
}

