/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry.recipe.entry;

import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingDynamic;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.CraftingContainer;

public class RecipeEntryScrap
extends RecipeEntryCraftingDynamic {
    public Item itemToScrap;
    public Item scrapYield;
    public ItemStack scrapYieldStack;

    public RecipeEntryScrap(Item itemToScrap, Item scrapYield) {
        this.itemToScrap = itemToScrap;
        this.scrapYield = scrapYield;
        this.scrapYieldStack = new ItemStack(scrapYield);
    }

    @Override
    public boolean matches(CraftingContainer inventorycrafting) {
        int itemToScrapCount = 0;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == this.itemToScrap.id) {
                    ++itemToScrapCount;
                    continue;
                }
                return false;
            }
        }
        return itemToScrapCount == true;
    }

    @Override
    public boolean matchesQuery(SearchQuery query) {
        return false;
    }

    @Override
    public ItemStack getCraftingResult(CraftingContainer inventorycrafting) {
        float itemToScrapDamage = 0.0f;
        float itemMaxDamage = 0.0f;
        Object scrapYieldStack = null;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null || stack.itemID != this.itemToScrap.id) continue;
                itemToScrapDamage = stack.getMetadata();
                itemMaxDamage = stack.getMaxDamage();
            }
        }
        float scrapYieldResult = (itemMaxDamage - itemToScrapDamage) / itemMaxDamage * 4.0f;
        if (scrapYieldResult >= 1.0f) {
            return new ItemStack(this.scrapYield, (int)scrapYieldResult);
        }
        return null;
    }

    @Override
    public ItemStack[] onCraftResult(CraftingContainer inventorycrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                ItemStack stack2 = stack.stackSize - 1 == 0 ? null : new ItemStack(stack.getItem(), stack.stackSize - 1);
                inventorycrafting.setSlotContentsAt(x, y, stack2);
            }
        }
        return returnStack;
    }

    @Override
    public int getRecipeSize() {
        return 2;
    }
}

