/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.server.entity.player.ServerPlayer;

public class BucketItem
extends Item {
    private int idToPlace;

    public BucketItem(String name, String namespaceId, int id, Block blockToPlace) {
        super(name, namespaceId, id);
        this.maxStackSize = 1;
        this.idToPlace = blockToPlace == null ? -1 : blockToPlace.id;
    }

    @Override
    public ItemStack onUseItem(ItemStack stack, World world, Player player) {
        float f = 1.0f;
        float f1 = player.xRotO + (player.xRot - player.xRotO) * f;
        float f2 = player.yRotO + (player.yRot - player.yRotO) * f;
        double posX = player.xo + (player.x - player.xo) * (double)f;
        float yOff = player instanceof ServerPlayer ? player.getHeightOffset() : 0.0f;
        double posY = player.yo + (player.y - player.yo) + (double)yOff;
        double posZ = player.zo + (player.z - player.zo) * (double)f;
        Vec3 vec3 = Vec3.getTempVec3(posX, posY, posZ);
        float f3 = MathHelper.cos(-f2 * 0.01745329f - (float)Math.PI);
        float f4 = MathHelper.sin(-f2 * 0.01745329f - (float)Math.PI);
        float f5 = -MathHelper.cos(-f1 * 0.01745329f);
        float f6 = MathHelper.sin(-f1 * 0.01745329f);
        float f7 = f4 * f5;
        float f8 = f6;
        float f9 = f3 * f5;
        double reachDistance = player.getGamemode().getBlockReachDistance();
        Vec3 vec31 = vec3.add((double)f7 * reachDistance, (double)f8 * reachDistance, (double)f9 * reachDistance);
        HitResult rayTraceResult = world.checkBlockCollisionBetweenPoints(vec3, vec31, this.idToPlace == 0);
        if (rayTraceResult == null || rayTraceResult.hitType != HitResult.HitType.TILE) {
            return stack;
        }
        int x = rayTraceResult.x;
        int y = rayTraceResult.y;
        int z = rayTraceResult.z;
        if (!world.canMineBlock(player, x, y, z)) {
            return stack;
        }
        if (this.idToPlace < 0) {
            return new ItemStack(Items.BUCKET);
        }
        Block block = world.getBlock(x, y, z);
        if (block != null && !block.hasTag(BlockTags.PLACE_OVERWRITES) && !block.hasTag(BlockTags.BROKEN_BY_FLUIDS)) {
            Side side = rayTraceResult.side;
            x += side.getOffsetX();
            y += side.getOffsetY();
            z += side.getOffsetZ();
        }
        if (y < 0 || y >= world.getHeightBlocks()) {
            return stack;
        }
        if (world.isAirBlock(x, y, z) || !world.getBlockMaterial(x, y, z).isSolid()) {
            if (world.dimension == Dimension.nether && this.idToPlace == Blocks.FLUID_WATER_FLOWING.id) {
                world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)z + 0.5, (double)y + 0.5, (double)x + 0.5, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    world.spawnParticle("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0, 0);
                }
            } else {
                if (this.idToPlace == Blocks.FLUID_WATER_FLOWING.id) {
                    world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "liquid.splash", 0.5f, 1.0f);
                }
                player.swingItem();
                Block block1 = world.getBlock(x, y, z);
                if (block1 != null) {
                    block1.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null, null);
                }
                world.setBlockAndMetadataWithNotify(x, y, z, this.idToPlace, 0);
            }
            if (player.getGamemode().consumeBlocks()) {
                return new ItemStack(Items.BUCKET);
            }
        }
        return stack;
    }
}

