/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.tool;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.item.tool.ToolItem;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ShovelToolItem
extends ToolItem {
    public ShovelToolItem(String name, String namespaceId, int id, ToolMaterial enumtoolmaterial) {
        super(name, namespaceId, id, 1, enumtoolmaterial, BlockTags.MINEABLE_BY_SHOVEL);
    }

    @Override
    public boolean canHarvestBlock(Mob entityLiving, ItemStack itemStack, Block block) {
        return block.hasTag(BlockTags.MINEABLE_BY_SHOVEL);
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int i1 = world.getBlockId(blockX, blockY, blockZ);
        int j1 = world.getBlockId(blockX, blockY + 1, blockZ);
        if (side != Side.BOTTOM && j1 == 0 && (i1 == Blocks.GRASS.id || i1 == Blocks.DIRT.id || i1 == Blocks.GRASS_RETRO.id || i1 == Blocks.FARMLAND_DIRT.id)) {
            Block block = Blocks.PATH_DIRT;
            world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Block.blocksList[i1], EnumBlockSoundEffectType.PLACE);
            if (!world.isClientSide) {
                world.setBlockWithNotify(blockX, blockY, blockZ, block.id);
                itemstack.damageItem(1, entityplayer);
            }
            return true;
        }
        return false;
    }
}

