/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.commands.AchievementCommand;
import net.minecraft.core.net.command.commands.BiomeCommand;
import net.minecraft.core.net.command.commands.ChunkCommand;
import net.minecraft.core.net.command.commands.ClearCommand;
import net.minecraft.core.net.command.commands.CloneCommand;
import net.minecraft.core.net.command.commands.DamageCommand;
import net.minecraft.core.net.command.commands.FillCommand;
import net.minecraft.core.net.command.commands.GameModeCommand;
import net.minecraft.core.net.command.commands.GameRuleCommand;
import net.minecraft.core.net.command.commands.GiveCommand;
import net.minecraft.core.net.command.commands.HealCommand;
import net.minecraft.core.net.command.commands.HelpCommand;
import net.minecraft.core.net.command.commands.KillCommand;
import net.minecraft.core.net.command.commands.MessageCommand;
import net.minecraft.core.net.command.commands.PlaceCommand;
import net.minecraft.core.net.command.commands.SayCommand;
import net.minecraft.core.net.command.commands.SeedCommand;
import net.minecraft.core.net.command.commands.SetBlockCommand;
import net.minecraft.core.net.command.commands.SetSpawnCommand;
import net.minecraft.core.net.command.commands.SpawnCommand;
import net.minecraft.core.net.command.commands.SummonCommand;
import net.minecraft.core.net.command.commands.TeleportCommand;
import net.minecraft.core.net.command.commands.TellRawCommand;
import net.minecraft.core.net.command.commands.TestForCommand;
import net.minecraft.core.net.command.commands.TimeCommand;
import net.minecraft.core.net.command.commands.WeatherCommand;
import net.minecraft.server.net.command.commands.ColorCommand;
import net.minecraft.server.net.command.commands.DeopCommand;
import net.minecraft.server.net.command.commands.DifficultyCommand;
import net.minecraft.server.net.command.commands.EmotesCommand;
import net.minecraft.server.net.command.commands.ListCommand;
import net.minecraft.server.net.command.commands.MeCommand;
import net.minecraft.server.net.command.commands.NicknameCommand;
import net.minecraft.server.net.command.commands.OpCommand;
import net.minecraft.server.net.command.commands.ScoreCommand;
import net.minecraft.server.net.command.commands.StopCommand;
import net.minecraft.server.net.command.commands.WhoIsCommand;
import org.jetbrains.annotations.Nullable;

public class CommandManager {
    private final boolean isServer;
    private final CommandDispatcher<CommandSource> DISPATCHER = new CommandDispatcher();
    private static final Collection<CommandRegistry> externalCommands = new ArrayList<CommandRegistry>();
    private static final Collection<CommandRegistry> externalServerCommands = new ArrayList<CommandRegistry>();

    public CommandManager(boolean isServer) {
        this.isServer = isServer;
    }

    public void init() {
        AchievementCommand.register(this.DISPATCHER);
        ClearCommand.register(this.DISPATCHER);
        KillCommand.register(this.DISPATCHER);
        SeedCommand.register(this.DISPATCHER);
        SetBlockCommand.register(this.DISPATCHER);
        SummonCommand.register(this.DISPATCHER);
        TeleportCommand.register(this.DISPATCHER);
        MessageCommand.register(this.DISPATCHER);
        SetSpawnCommand.register(this.DISPATCHER);
        TimeCommand.register(this.DISPATCHER);
        GameModeCommand.register(this.DISPATCHER);
        WeatherCommand.register(this.DISPATCHER);
        SpawnCommand.register(this.DISPATCHER);
        PlaceCommand.register(this.DISPATCHER);
        HelpCommand.register(this.DISPATCHER);
        ChunkCommand.register(this.DISPATCHER);
        GiveCommand.register(this.DISPATCHER);
        GameRuleCommand.register(this.DISPATCHER);
        FillCommand.register(this.DISPATCHER);
        CloneCommand.register(this.DISPATCHER);
        BiomeCommand.register(this.DISPATCHER);
        SayCommand.register(this.DISPATCHER);
        TellRawCommand.register(this.DISPATCHER);
        TestForCommand.register(this.DISPATCHER);
        DamageCommand.register(this.DISPATCHER);
        HealCommand.register(this.DISPATCHER);
        if (this.isServer) {
            StopCommand.register(this.DISPATCHER);
            OpCommand.register(this.DISPATCHER);
            DeopCommand.register(this.DISPATCHER);
            ListCommand.register(this.DISPATCHER);
            DifficultyCommand.register(this.DISPATCHER);
            ColorCommand.register(this.DISPATCHER);
            NicknameCommand.register(this.DISPATCHER);
            WhoIsCommand.register(this.DISPATCHER);
            ScoreCommand.register(this.DISPATCHER);
            MeCommand.register(this.DISPATCHER);
            EmotesCommand.register(this.DISPATCHER);
            for (CommandRegistry registry : externalServerCommands) {
                registry.register(this.DISPATCHER);
            }
        }
        for (CommandRegistry registry : externalCommands) {
            registry.register(this.DISPATCHER);
        }
    }

    public int execute(String s, CommandSource commandSource) throws CommandSyntaxException {
        return this.DISPATCHER.execute(s, commandSource);
    }

    public CommandDispatcher<CommandSource> getDispatcher() {
        return this.DISPATCHER;
    }

    @Nullable
    public static <S> CommandSyntaxException getParseException(ParseResults<S> parseResults) {
        if (!parseResults.getReader().canRead()) {
            return null;
        }
        if (parseResults.getExceptions().size() == 1) {
            return parseResults.getExceptions().values().iterator().next();
        }
        if (parseResults.getContext().getRange().isEmpty()) {
            return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parseResults.getReader());
        }
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(parseResults.getReader());
    }

    public static void registerCommand(CommandRegistry registry) {
        externalCommands.add(registry);
    }

    public static void registerServerCommand(CommandRegistry registry) {
        externalServerCommands.add(registry);
    }

    @FunctionalInterface
    public static interface CommandRegistry {
        public void register(CommandDispatcher<CommandSource> var1);
    }
}

