/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.achievement.Achievement;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.AchievementArgumentType;
import net.minecraft.core.net.command.arguments.EntityArgumentType;
import net.minecraft.core.net.command.helpers.EntitySelector;

public class AchievementCommand {
    private static final SimpleCommandExceptionType PLAYER_ALREADY_HAS_ACHIEVEMENT = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("command.commands.achievement.grant.exception_already_has_achievement"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("achievement").requires(CommandSource::hasAdmin)).then(LiteralArgumentBuilder.literal("grant").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument("entities", EntityArgumentType.players()).then(RequiredArgumentBuilder.argument("achievement", AchievementArgumentType.achievement()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            List<? extends Entity> entities = c.getArgument("entities", EntitySelector.class).get(source);
            Achievement achievement = c.getArgument("achievement", Achievement.class);
            if (entities.size() == 1 && ((Player)entities.get(0)).getStat(achievement) != 0) {
                throw PLAYER_ALREADY_HAS_ACHIEVEMENT.create();
            }
            ArrayList<Achievement> achievements = new ArrayList<Achievement>();
            achievements.add(achievement);
            while (((Achievement)achievements.get((int)(achievements.size() - 1))).parent != null) {
                achievements.add(((Achievement)achievements.get((int)(achievements.size() - 1))).parent);
            }
            for (int i = 0; i < achievements.size(); ++i) {
                for (Entity entity : entities) {
                    ((Player)entity).triggerAchievement((Stat)achievements.get(achievements.size() - 1 - i));
                }
            }
            AchievementCommand.sendContextualMessage(source, entities, achievement);
            return 1;
        }))).then(LiteralArgumentBuilder.literal("*").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            List<? extends Entity> entities = c.getArgument("entities", EntitySelector.class).get(source);
            for (Achievement achievement : Achievements.achievementList) {
                ArrayList<Achievement> achievements = new ArrayList<Achievement>();
                achievements.add(achievement);
                while (((Achievement)achievements.get((int)(achievements.size() - 1))).parent != null) {
                    achievements.add(((Achievement)achievements.get((int)(achievements.size() - 1))).parent);
                }
                for (int i = 0; i < achievements.size(); ++i) {
                    for (Entity entity : entities) {
                        ((Player)entity).triggerAchievement((Stat)achievements.get(achievements.size() - 1 - i));
                    }
                }
            }
            AchievementCommand.sendWildcardContextualMessage(source, entities);
            return 1;
        })))));
    }

    private static void sendContextualMessage(CommandSource source, List<? extends Entity> entities, Achievement achievement) {
        if (entities.size() == 1) {
            source.sendTranslatableMessage("command.commands.achievement.grant.success_single_entity", achievement.getStatName().trim(), ((Mob)entities.get(0)).getDisplayName());
        } else {
            source.sendTranslatableMessage("command.commands.achievement.grant.success_multiple_entities", achievement.getStatName(), entities.size());
        }
    }

    private static void sendWildcardContextualMessage(CommandSource source, List<? extends Entity> entities) {
        if (entities.size() == 1) {
            source.sendTranslatableMessage("command.commands.achievement.grant.all.success_single_entity", ((Mob)entities.get(0)).getDisplayName());
        } else {
            source.sendTranslatableMessage("command.commands.achievement.grant.all.success_multiple_entities", entities.size());
        }
    }
}

