/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.helpers;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.nbt.CompoundTag;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.block.Block;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.helpers.ArgumentParser;
import net.minecraft.core.net.command.helpers.BlockInput;
import net.minecraft.core.net.command.util.CommandHelper;

public class BlockArgumentParser
extends ArgumentParser {
    private static final SimpleCommandExceptionType INVALID_BLOCK = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("command.argument_types.block.invalid_block"));
    private Block block;
    private int metadata = 0;
    private CompoundTag tag = new CompoundTag();

    public BlockArgumentParser(StringReader reader) {
        super(reader);
    }

    private CompletableFuture<Suggestions> suggestBlocks(SuggestionsBuilder suggestionsBuilder, Consumer<SuggestionsBuilder> consumer) {
        SuggestionsBuilder suggestionsBuilder2 = suggestionsBuilder.createOffset(this.startPosition);
        consumer.accept(suggestionsBuilder2);
        return suggestionsBuilder.add(suggestionsBuilder2).buildFuture();
    }

    public BlockInput parse() throws CommandSyntaxException {
        this.startPosition = this.reader.getCursor();
        this.suggestions = this::suggestBlocks;
        this.parseBlock();
        this.suggestions = this::suggestOpenMetadataOrTag;
        if (this.reader.canRead() && this.reader.peek() == '[') {
            this.metadata = this.parseMetadata();
        }
        if (this.reader.canRead() && this.reader.peek() == '{') {
            this.reader.skip();
            this.suggestions = CommandHelper.NO_SUGGESTIONS;
            this.tag = this.parseCompound();
        }
        return new BlockInput(this.block, this.metadata, this.tag);
    }

    private void parseBlock() throws CommandSyntaxException {
        String string = this.reader.readString();
        boolean isAir = false;
        for (Block blockInList : Block.blocksList) {
            if (blockInList == null) continue;
            if (CommandHelper.matchesKeyString(blockInList.getKey(), string)) {
                this.block = blockInList;
                continue;
            }
            if (!CommandHelper.matchesKeyString("tile.air", string)) continue;
            this.block = null;
            isAir = true;
        }
        if (this.block == null && !isAir) {
            throw INVALID_BLOCK.createWithContext(this.reader);
        }
    }

    @Override
    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder suggestionsBuilder, Consumer<SuggestionsBuilder> consumer) {
        return (CompletableFuture)this.suggestions.apply(suggestionsBuilder.createOffset(this.reader.getCursor()), consumer);
    }
}

