/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.world.World;

public class BlockUpdatePacket
extends Packet {
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public int type;
    public int metadata;

    public BlockUpdatePacket() {
        this.isChunkDataPacket = true;
    }

    public BlockUpdatePacket(int i, int j, int k, World world) {
        this.isChunkDataPacket = true;
        this.xPosition = i;
        this.yPosition = j;
        this.zPosition = k;
        this.type = world.getBlockId(i, j, k);
        this.metadata = world.getBlockMetadata(i, j, k);
    }

    @Override
    public void read(DataInputStream dis) throws IOException {
        this.xPosition = dis.readInt();
        this.yPosition = dis.readShort();
        this.zPosition = dis.readInt();
        this.type = dis.readShort();
        this.metadata = dis.read();
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.xPosition);
        dos.writeShort(this.yPosition);
        dos.writeInt(this.zPosition);
        dos.writeShort(this.type);
        dos.write(this.metadata);
    }

    @Override
    public void handlePacket(PacketHandler packetHandler) {
        packetHandler.handleBlockChange(this);
    }

    @Override
    public int getEstimatedSize() {
        return 11;
    }
}

