/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type.nether;

import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderSingleBiome;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.perlin.nether.ChunkGeneratorNether;
import net.minecraft.core.world.type.WorldType;

public class WorldTypeNether
extends WorldType {
    public WorldTypeNether(WorldType.Properties properties) {
        super(properties);
    }

    public static WorldType.Properties defaultProperties(String translationKey) {
        return WorldType.Properties.of(translationKey).brightnessRamp(WorldTypeNether.getLightRamp()).oceanBlock(Blocks.FLUID_LAVA_STILL).fillerBlock(Blocks.NETHERRACK).noClouds().noSky().withCeiling().bounds(128, 255, 32);
    }

    private static float[] getLightRamp() {
        float[] brightnessRamp = new float[32];
        float f = 0.1f;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            brightnessRamp[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
        return brightnessRamp;
    }

    @Override
    public void onWorldCreation(World world) {
        super.onWorldCreation(world);
        world.setWorldTime(72000L);
    }

    @Override
    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderSingleBiome(Biomes.NETHER_NETHER, 1.0, 0.0, 1.0);
    }

    @Override
    public ChunkGenerator createChunkGenerator(World world) {
        return new ChunkGeneratorNether(world);
    }

    @Override
    public boolean isValidSpawn(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public float getCelestialAngle(World world, long tick, float partialTick) {
        return 0.5f;
    }

    @Override
    public float[] getSunriseColor(float timeOfDay, float partialTick) {
        return new float[4];
    }

    @Override
    public int getSkyDarken(World world, long tick, float partialTick) {
        return 0;
    }

    @Override
    public Vec3 getFogColor(World world, double x, double y, double z, float celestialAngle, float partialTick) {
        if (Colorizers.fog.isEnabled()) {
            int x1 = MathHelper.floor(x);
            int y1 = MathHelper.floor(y);
            int z1 = MathHelper.floor(z);
            int color = Colorizers.fog.getColor(world, x1, y1, z1);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            return Vec3.getTempVec3(r, g, b);
        }
        return Vec3.getTempVec3(0.0, 0.0, 0.0);
    }
}

