/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.EntityArgumentType;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.core.net.packet.UpdatePlayerProfilePacket;
import net.minecraft.server.entity.player.ServerPlayer;

public class NicknameCommand {
    private static final SimpleCommandExceptionType NICKNAME_TOO_LARGE = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("commands.commander.nickname.exception_too_large"));
    private static final SimpleCommandExceptionType NICKNAME_TOO_SMALL = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("commands.commander.nickname.exception_too_small"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralCommandNode<CommandSource> command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("nickname").then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("set").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument("target", EntityArgumentType.player()).requires(CommandSource::hasAdmin)).then(RequiredArgumentBuilder.argument("nickname", StringArgumentType.greedyString()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            String nickname = c.getArgument("nickname", String.class);
            if (nickname.length() > 16) {
                throw NICKNAME_TOO_LARGE.create();
            }
            if (nickname.isEmpty()) {
                throw NICKNAME_TOO_SMALL.create();
            }
            List<? extends Entity> entities = entitySelector.get(source);
            ServerPlayer player = (ServerPlayer)entities.get(0);
            player.nickname = nickname;
            player.hadNicknameSet = true;
            player.mcServer.playerList.sendPacketToAllPlayers(new UpdatePlayerProfilePacket(player.username, player.nickname, player.uuid, player.score, player.chatColor, true, player.isOperator()));
            if (source.getSender() == player) {
                source.sendTranslatableMessage("commands.commander.nickname.set.success", nickname);
            } else {
                source.sendTranslatableMessage("commands.commander.nickname.set.success_other", player.username, nickname);
                source.sendTranslatableMessage(player, "commands.commander.nickname.set.success_receiver", nickname);
            }
            return 1;
        })))).then(RequiredArgumentBuilder.argument("nickname", StringArgumentType.greedyString()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            String nickname = c.getArgument("nickname", String.class);
            if (nickname.length() > 16) {
                throw NICKNAME_TOO_LARGE.create();
            }
            if (nickname.isEmpty()) {
                throw NICKNAME_TOO_SMALL.create();
            }
            ServerPlayer player = (ServerPlayer)source.getSender();
            if (player == null) {
                throw CommandExceptions.notInWorld().create();
            }
            player.nickname = nickname;
            player.hadNicknameSet = true;
            player.mcServer.playerList.sendPacketToAllPlayers(new UpdatePlayerProfilePacket(player.username, player.nickname, player.uuid, player.score, player.chatColor, true, player.isOperator()));
            source.sendTranslatableMessage("commands.commander.nickname.set.success", nickname);
            return 1;
        })))).then(LiteralArgumentBuilder.literal("get").then(RequiredArgumentBuilder.argument("target", EntityArgumentType.player()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            ServerPlayer player = (ServerPlayer)entities.get(0);
            source.sendTranslatableMessage("commands.commander.nickname.get.success", player.username, player.nickname);
            return 1;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("reset").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument("target", EntityArgumentType.player()).requires(CommandSource::hasAdmin)).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            ServerPlayer player = (ServerPlayer)entities.get(0);
            player.nickname = "";
            player.hadNicknameSet = false;
            player.mcServer.playerList.sendPacketToAllPlayers(new UpdatePlayerProfilePacket(player.username, player.nickname, player.uuid, player.score, player.chatColor, true, player.isOperator()));
            if (source.getSender() == player) {
                source.sendTranslatableMessage("commands.commander.nickname.reset.success", new Object[0]);
            } else {
                source.sendTranslatableMessage("commands.commander.nickname.reset.success_other", player.username);
                source.sendTranslatableMessage(player, "commands.commander.nickname.reset.success_receiver", new Object[0]);
            }
            return 1;
        }))).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            ServerPlayer player = (ServerPlayer)source.getSender();
            if (player == null) {
                throw CommandExceptions.notInWorld().create();
            }
            player.nickname = "";
            player.hadNicknameSet = false;
            player.mcServer.playerList.sendPacketToAllPlayers(new UpdatePlayerProfilePacket(player.username, player.nickname, player.uuid, player.score, player.chatColor, true, player.isOperator()));
            source.sendTranslatableMessage("commands.commander.nickname.reset.success", player.username);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("nick").redirect(command));
    }
}

