/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.EntityArgumentType;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.core.net.command.util.CommandHelper;
import net.minecraft.core.net.packet.UpdatePlayerProfilePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;
import net.minecraft.server.net.command.IServerCommandSource;

public class ScoreCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("score").then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("get").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            Player player = source.getSender();
            if (player == null) {
                throw CommandExceptions.notInWorld().create();
            }
            source.sendTranslatableMessage("commands.commander.score.get.success", player.score);
            return player.score;
        })).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument("target", EntityArgumentType.player()).requires(CommandSource::hasAdmin)).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            Player player = (Player)entitySelector.get(source).get(0);
            if (player == source.getSender()) {
                source.sendTranslatableMessage("commands.commander.score.get.success", player.score);
            } else {
                source.sendTranslatableMessage("commands.commander.score.get.success_other", CommandHelper.getEntityName(player), player.score);
            }
            return player.score;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("set").requires(CommandSource::hasAdmin)).then(RequiredArgumentBuilder.argument("target", EntityArgumentType.players()).then(RequiredArgumentBuilder.argument("score", IntegerArgumentType.integer(0, Integer.MAX_VALUE)).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            int score = c.getArgument("score", Integer.class);
            for (Entity entity : entities) {
                ScoreCommand.setPlayerScore(source, (ServerPlayer)entity, score);
            }
            return score;
        }))))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("add").requires(CommandSource::hasAdmin)).then(RequiredArgumentBuilder.argument("target", EntityArgumentType.players()).then(RequiredArgumentBuilder.argument("score", IntegerArgumentType.integer(0, Integer.MAX_VALUE)).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            int score = c.getArgument("score", Integer.class);
            for (Entity entity : entities) {
                ScoreCommand.setPlayerScore(source, (ServerPlayer)entity, ((ServerPlayer)entity).score + score);
            }
            return score;
        })))));
    }

    private static void setPlayerScore(CommandSource source, ServerPlayer player, int score) throws CommandSyntaxException {
        if (!(source instanceof IServerCommandSource)) {
            throw CommandExceptions.multiplayerWorldOnly().create();
        }
        MinecraftServer server = ((IServerCommandSource)((Object)source)).getServer();
        player.score = score;
        server.playerList.sendPacketToAllPlayers(new UpdatePlayerProfilePacket(player.username, player.nickname, player.uuid, player.score, player.chatColor, true, player.isOperator()));
        if (player == source.getSender()) {
            source.sendTranslatableMessage("commands.commander.score.set.success", score);
        } else {
            source.sendTranslatableMessage("commands.commander.score.set.success_other", CommandHelper.getEntityName(player), score);
            source.sendTranslatableMessage(player, "commands.commander.score.set.success_receiver", score);
        }
    }
}

