/*
 * Decompiled with CFR 0.152.
 */
package com.b100.utils;

import com.b100.utils.FileUtils;
import com.b100.utils.StreamUtils;
import com.b100.utils.Utils;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.imageio.ImageIO;

public abstract class ImageUtils {
    public static void copyImageToClipboard(BufferedImage image) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new TransferableImage(image), null);
    }

    public static BufferedImage loadExternalImage(String path) {
        return ImageUtils.loadExternalImage(new File(path));
    }

    public static BufferedImage loadExternalImage(File file) {
        BufferedImage image;
        InputStream stream;
        Utils.requireNonNull(file);
        if (!file.exists()) {
            throw new RuntimeException("File doesn't exist: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new RuntimeException("Not a file: " + file.getAbsolutePath());
        }
        try {
            stream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not open file", e);
        }
        try {
            image = ImageIO.read(stream);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Could not read Image", e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(stream);
                throw throwable;
            }
        }
        StreamUtils.close(stream);
        return image;
    }

    public static void saveExternalImage(BufferedImage image, String path) {
        ImageUtils.saveExternalImage(image, new File(path));
    }

    public static void saveExternalImage(BufferedImage image, File file) {
        FileUtils.createNewFile(file);
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            throw new RuntimeException("Error saving Image", e);
        }
    }

    private static class TransferableImage
    implements Transferable {
        private Image image;

        public TransferableImage(Image image) {
            this.image = Utils.requireNonNull(image);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == DataFlavor.imageFlavor;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor == DataFlavor.imageFlavor) {
                return this.image;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

