/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.TextFieldElement;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.client.player.controller.PlayerControllerSP;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.type.WorldTypeGroups;
import org.lwjgl.input.Keyboard;

public class CreateWorldScreen
extends Screen {
    private int overrideSpawnX;
    private int overrideSpawnY;
    private int overrideSpawnZ;
    private Screen textField;
    private TextFieldElement textboxWorldName;
    private TextFieldElement textboxSeed;
    private ButtonElement createWorldButton;
    private ButtonElement gamemodeButton;
    private ButtonElement cheatsButton;
    private ButtonElement worldTypeButton;
    private ButtonElement buttonRandomWorldName;
    private ButtonElement buttonRandomSeed;
    private String folderName;
    private boolean createClicked;
    private Gamemode selectedGamemode = Gamemode.survival;
    private boolean cheatsEnabled = false;
    private WorldTypeGroups.Group worldTypeGroup = WorldTypeGroups.DEFAULT;
    private long seed = new Random().nextLong();

    public CreateWorldScreen(Screen guiscreen) {
        this.textField = guiscreen;
    }

    @Override
    public void tick() {
        this.textboxWorldName.updateCursorCounter();
        this.textboxSeed.updateCursorCounter();
    }

    @Override
    public void init() {
        I18n i18n = I18n.getInstance();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttons.clear();
        this.createWorldButton = new ButtonElement(0, this.width / 2 - 100, this.height / 4 + 104 + 12, i18n.translateKey("gui.create_world.button.create_new_world"));
        this.buttons.add(this.createWorldButton);
        this.buttons.add(new ButtonElement(1, this.width / 2 - 100, this.height / 4 + 128 + 12, i18n.translateKey("gui.create_world.button.cancel")));
        this.textboxWorldName = new TextFieldElement(this, this.font, this.width / 2 - 100, 60, 176, 20, "", i18n.translateKey("gui.create_world.label.new_world"));
        this.textboxWorldName.setMaxStringLength(32);
        this.textboxSeed = new TextFieldElement(this, this.font, this.width / 2 - 100, 100, 176, 20, "", Long.toString(this.seed));
        this.gamemodeButton = new ButtonElement(2, this.width / 2 - 100, 124, 98, 20, "");
        this.buttons.add(this.gamemodeButton);
        this.cheatsButton = new ButtonElement(3, this.width / 2 - 100 + 102, 124, 98, 20, "");
        this.buttons.add(this.cheatsButton);
        this.worldTypeButton = new ButtonElement(4, this.width / 2 - 100, 148, "");
        this.buttons.add(this.worldTypeButton);
        this.buttonRandomWorldName = new ButtonElement(5, this.width / 2 + 100 - 20, 60, 20, 20, "").setTextures("minecraft:gui/misc/button_random", "minecraft:gui/misc/button_random_highlighted", "minecraft:gui/misc/button_random");
        this.buttons.add(this.buttonRandomWorldName);
        this.buttonRandomSeed = new ButtonElement(6, this.width / 2 + 100 - 20, 100, 20, 20, "").setTextures("minecraft:gui/misc/button_random", "minecraft:gui/misc/button_random_highlighted", "minecraft:gui/misc/button_random");
        this.buttons.add(this.buttonRandomSeed);
        this.updateButtons();
        this.updateFolderName();
    }

    private void updateFolderName() {
        char[] ac;
        this.folderName = this.textboxWorldName.getText().trim();
        for (char c : ac = ChatAllowedCharacters.ALLOWED_CHARACTERS_ARRAY) {
            this.folderName = this.folderName.replace(c, '_');
        }
        if (MathHelper.stringNullOrLengthZero(this.folderName)) {
            this.folderName = "New World";
        }
        this.folderName = CreateWorldScreen.generateUnusedFolderName(this.mc.getSaveFormat(), this.folderName);
    }

    public static String generateUnusedFolderName(ISaveFormat isaveformat, String s) {
        int count = 1;
        String newString = s;
        while (isaveformat.getLevelData(newString) != null) {
            newString = s + " (" + count + ")";
            ++count;
        }
        return newString;
    }

    @Override
    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void buttonClicked(ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 1) {
            this.mc.displayScreen(this.textField);
        } else if (button.id == 0) {
            this.mc.displayScreen(null);
            if (this.createClicked) {
                return;
            }
            this.createClicked = true;
            long seed = this.seed;
            String seedText = this.textboxSeed.getText();
            if (!MathHelper.stringNullOrLengthZero(seedText)) {
                try {
                    long parsedSeed = Long.parseLong(seedText);
                    if (parsedSeed != 0L) {
                        seed = parsedSeed;
                    }
                }
                catch (NumberFormatException e) {
                    seed = seedText.hashCode();
                }
            }
            this.mc.playerController = new PlayerControllerSP(this.mc);
            String worldName = this.textboxWorldName.getText();
            if (worldName.isEmpty()) {
                worldName = I18n.getInstance().translateKey("gui.create_world.label.new_world");
            }
            this.mc.startWorld(this.folderName, worldName, seed, this.worldTypeGroup);
            this.mc.thePlayer.setGamemode(this.selectedGamemode);
            if (this.selectedGamemode == Gamemode.adventure) {
                this.mc.thePlayer.inventory.insertItem(Items.TOOL_AXE_WOOD.getDefaultStack(), true);
            }
            if (this.mc.worldPresetName != null) {
                this.mc.thePlayer.setPos(this.overrideSpawnX, this.overrideSpawnY, this.overrideSpawnZ);
            }
            this.mc.theWorld.getLevelData().setCheatsEnabled(this.cheatsEnabled);
            this.mc.displayScreen(null);
        } else if (button == this.gamemodeButton) {
            I18n i18n = I18n.getInstance();
            List<Gamemode> gamemodeList = Gamemode.getPublicGamemodes();
            this.selectedGamemode = gamemodeList.get((gamemodeList.indexOf(this.selectedGamemode) + 1) % gamemodeList.size());
            this.cheatsEnabled = this.selectedGamemode == Gamemode.creative;
            this.updateButtons();
        } else if (button == this.cheatsButton) {
            I18n i18n = I18n.getInstance();
            this.cheatsEnabled = !this.cheatsEnabled;
            this.updateButtons();
        } else if (button == this.worldTypeButton) {
            I18n i18n = I18n.getInstance();
            String[] keys = new String[WorldTypeGroups.GROUPS.size()];
            String[] descs = new String[WorldTypeGroups.GROUPS.size()];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = i18n.translateKey(WorldTypeGroups.GROUPS.get(i).get(Dimension.OVERWORLD).getLanguageKey() + ".name");
                descs[i] = i18n.translateKey(WorldTypeGroups.GROUPS.get(i).get(Dimension.OVERWORLD).getLanguageKey() + ".desc") + "\n" + TextFormatting.GRAY + Registries.WORLD_TYPES.getKey(WorldTypeGroups.GROUPS.get(i).get(Dimension.OVERWORLD));
            }
            PopupScreen popup = new PopupBuilder(this, 150).closeOnEsc(0).closeOnClickOut(0).withLabel("gui.create_world.label.select_world_type").withList("worldTypeList", 140, keys, descs, WorldTypeGroups.GROUPS.indexOf(this.worldTypeGroup), true).withOnCloseListener((statusCode, results) -> {
                if (statusCode == 1) {
                    this.worldTypeGroup = WorldTypeGroups.GROUPS.get((Integer)results.get("worldTypeList"));
                    this.updateButtons();
                }
            }).build();
            this.mc.displayScreen(popup);
        } else if (button == this.buttonRandomWorldName) {
            this.textboxWorldName.setText(I18n.getInstance().getCurrentLanguage().getRandomWorldName());
            this.updateFolderName();
        } else if (button == this.buttonRandomSeed) {
            this.seed = new Random().nextLong();
            this.textboxSeed.setPlaceholder(Long.toString(this.seed));
            this.textboxSeed.setText("");
        }
    }

    private void updateButtons() {
        I18n i18n = I18n.getInstance();
        this.gamemodeButton.displayString = i18n.translateKeyAndFormat("gui.create_world.button.gamemode", i18n.translateNameKey(this.selectedGamemode.getLanguageKey()));
        this.cheatsButton.displayString = i18n.translateKeyAndFormat("gui.create_world.button.cheats", i18n.translateKey(this.cheatsEnabled ? "gui.create_world.button.cheats.on" : "gui.create_world.button.cheats.off"));
        this.worldTypeButton.displayString = i18n.translateKeyAndFormat("gui.create_world.button.world_type", i18n.translateNameKey(this.worldTypeGroup.get(Dimension.OVERWORLD).getLanguageKey()));
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey != Keyboard.KEY_BACK) {
            super.keyPressed(eventCharacter, eventKey, mx, my);
        }
        if (this.textboxWorldName.isFocused) {
            this.textboxWorldName.textboxKeyTyped(eventCharacter, eventKey);
        } else if (this.textboxSeed.isFocused) {
            this.textboxSeed.textboxKeyTyped(eventCharacter, eventKey);
        }
        if (eventCharacter == '\r') {
            this.buttonClicked((ButtonElement)this.buttons.get(0));
        }
        this.updateFolderName();
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        this.textboxWorldName.mouseClicked(mx, my, buttonNum);
        this.textboxSeed.mouseClicked(mx, my, buttonNum);
    }

    @Override
    public void render(int xm, int ym, float partialTick) {
        I18n stringtranslate = I18n.getInstance();
        this.renderBackground();
        this.drawStringCentered(this.font, stringtranslate.translateKey("gui.create_world.label.title"), this.width / 2, 20, 0xFFFFFF);
        this.drawString(this.font, stringtranslate.translateKey("gui.create_world.label.world_name"), this.width / 2 - 100, 47, 0xA0A0A0);
        this.drawString(this.font, stringtranslate.translateKey("gui.create_world.label.seed"), this.width / 2 - 100, 88, 0xA0A0A0);
        this.textboxWorldName.drawTextBox();
        this.textboxSeed.drawTextBox();
        super.render(xm, ym, partialTick);
    }

    @Override
    public void selectNextField() {
        if (this.textboxWorldName.isFocused) {
            this.textboxWorldName.setFocused(false);
            this.textboxSeed.setFocused(true);
        } else {
            this.textboxWorldName.setFocused(true);
            this.textboxSeed.setFocused(false);
        }
    }

    public void runPreset(String name, String seed, int spawnX, int spawnY, int spawnZ) {
        this.overrideSpawnX = spawnX;
        this.overrideSpawnY = spawnY;
        this.overrideSpawnZ = spawnZ;
        this.textboxWorldName.setText(name);
        this.textboxSeed.setText(seed);
        this.updateFolderName();
        this.selectedGamemode = Gamemode.creative;
        this.buttonClicked(this.createWorldButton);
    }
}

