/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.CreateWorldScreen;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScrolledSelectionList;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.client.player.controller.PlayerControllerSP;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.SaveFile;
import net.minecraft.core.world.type.WorldType;
import org.lwjgl.input.Keyboard;

public class SelectWorldScreen
extends Screen {
    private final DateFormat dateFormatter = new SimpleDateFormat();
    protected String stringTitle = "Select world";
    private boolean selected = false;
    private int selectedWorld = -1;
    private List<SaveFile> saveList;
    private WorldSlot worldSlotContainer;
    private String stringWorld;
    private String stringConversion;
    private boolean deleting;
    private ButtonElement buttonRename;
    private ButtonElement buttonSelect;
    private ButtonElement buttonDelete;

    public SelectWorldScreen(Screen parent) {
        super(parent);
    }

    @Override
    public void init() {
        I18n i18n = I18n.getInstance();
        this.stringTitle = i18n.translateKey("gui.select_world.label.title");
        this.stringWorld = i18n.translateKey("gui.select_world.label.world");
        this.stringConversion = i18n.translateKey("gui.select_world.label.must_be_converted");
        this.loadSaves();
        this.worldSlotContainer = new WorldSlot();
        this.initButtons();
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        super.keyPressed(eventCharacter, eventKey, mx, my);
        if (eventKey == Keyboard.KEY_UP && this.selectedWorld > 0) {
            this.worldSlotContainer.selectItem(this.selectedWorld - 1, false);
        }
        if (eventKey == Keyboard.KEY_DOWN && this.selectedWorld < this.saveList.size() - 1) {
            this.worldSlotContainer.selectItem(this.selectedWorld + 1, false);
        }
        if (eventKey == Keyboard.KEY_DELETE) {
            this.tryDeleteWorld(Keyboard.isKeyDown((int)Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown((int)Keyboard.KEY_RSHIFT));
        }
    }

    private void loadSaves() {
        ISaveFormat isaveformat = this.mc.getSaveFormat();
        this.saveList = isaveformat.getSaveFileList();
        Collections.sort(this.saveList);
        if (this.selectedWorld >= this.saveList.size()) {
            this.selectedWorld = -1;
        }
    }

    protected String getSaveFileName(int i) {
        return this.saveList.get(i).getFileName();
    }

    protected String getSaveName(int i) {
        String s = this.saveList.get(i).getDisplayName();
        if (s == null || MathHelper.stringNullOrLengthZero(s)) {
            I18n i18n = I18n.getInstance();
            s = i18n.translateKeyAndFormat(this.stringWorld, i + 1);
        }
        return s;
    }

    public void initButtons() {
        I18n i18n = I18n.getInstance();
        this.buttonSelect = new ButtonElement(1, this.width / 2 - 154, this.height - 52, 150, 20, i18n.translateKey("gui.select_world.button.play_selected_world"));
        this.buttons.add(this.buttonSelect);
        this.buttonRename = new ButtonElement(6, this.width / 2 - 154, this.height - 28, 70, 20, i18n.translateKey("gui.select_world.button.rename"));
        this.buttons.add(this.buttonRename);
        this.buttonDelete = new ButtonElement(2, this.width / 2 - 74, this.height - 28, 70, 20, i18n.translateKey("gui.select_world.button.delete"));
        this.buttons.add(this.buttonDelete);
        this.buttons.add(new ButtonElement(3, this.width / 2 + 4, this.height - 52, 150, 20, i18n.translateKey("gui.select_world.button.create_new_world")));
        this.buttons.add(new ButtonElement(0, this.width / 2 + 4, this.height - 28, 150, 20, i18n.translateKey("gui.select_world.button.cancel")));
        this.buttonSelect.enabled = false;
        this.buttonRename.enabled = false;
        this.buttonDelete.enabled = false;
    }

    public void deletePresetWorld(String name) {
        for (int i = 0; i < this.saveList.size(); ++i) {
            SaveFile save = this.saveList.get(i);
            if (!save.getDisplayName().equals(name)) continue;
            this.deleting = true;
            this.deleteWorld(true, i);
            --i;
        }
    }

    void tryDeleteWorld(boolean skipConfirm) {
        if (this.selectedWorld < 0 || this.selectedWorld >= this.saveList.size()) {
            return;
        }
        String s = this.getSaveName(this.selectedWorld);
        if (s != null) {
            this.deleting = true;
            if (skipConfirm) {
                this.deleteWorld(true, this.selectedWorld);
            } else {
                I18n i18n = I18n.getInstance();
                PopupScreen popup = new PopupBuilder(this, 250).closeOnEsc(0).withLabel("gui.select_world.label.delete_title").withLabel("gui.select_world.label.delete_confirm.1").withLabelLiteral(i18n.translateKeyAndFormat("gui.select_world.label.delete_confirm.2", s)).withLabelLiteral("").withButtonGroup("endButtons", new String[]{"gui.select_world.button.delete", "gui.select_world.button.cancel"}, new int[]{1, 0}).withOnCloseListener((statusCode, results) -> {
                    if (statusCode == 1) {
                        this.deleteWorld(true, this.selectedWorld);
                    }
                }).build();
                this.mc.displayScreen(popup);
            }
        }
    }

    @Override
    protected void buttonClicked(ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 2) {
            this.tryDeleteWorld(false);
        } else if (button.id == 1) {
            this.selectWorld(this.selectedWorld);
        } else if (button.id == 3) {
            this.mc.displayScreen(new CreateWorldScreen(this));
        } else if (button.id == 6) {
            I18n i18n = I18n.getInstance();
            PopupScreen popup = new PopupBuilder(this, 140).closeOnEsc(0).closeOnEnter(1).withLabel("gui.select_world.label.rename_title").withLabel("gui.select_world.label.world_name").withTextField("nameField", this.getSaveName(this.selectedWorld)).withButtonGroup("endButtons", new String[]{"gui.select_world.button.rename", "gui.select_world.button.cancel"}, new int[]{1, 0}).withOnCloseListener((statusCode, results) -> {
                if (statusCode == 1) {
                    String text = (String)results.get("nameField");
                    ISaveFormat format = this.mc.getSaveFormat();
                    format.renameWorld(this.getSaveFileName(this.selectedWorld), text);
                    this.loadSaves();
                }
            }).build();
            this.mc.displayScreen(popup);
        } else if (button.id == 0) {
            this.mc.displayScreen(this.parentScreen);
        }
    }

    public void selectWorld(int i) {
        SaveFile save = this.saveList.get(i);
        if (save.isCorrupted()) {
            return;
        }
        if (save.getNeedsConversion()) {
            // empty if block
        }
        this.mc.displayScreen(null);
        if (this.selected) {
            return;
        }
        this.selected = true;
        this.mc.playerController = new PlayerControllerSP(this.mc);
        String s = this.getSaveFileName(i);
        if (s == null) {
            s = "World" + i;
        }
        this.mc.startWorld(s, this.getSaveName(i), 0L);
        this.mc.displayScreen(null);
    }

    public void deleteWorld(boolean flag, int i) {
        if (this.deleting) {
            this.deleting = false;
            if (flag) {
                ISaveFormat isaveformat = this.mc.getSaveFormat();
                isaveformat.flushCache();
                isaveformat.deleteSave(this.getSaveFileName(i));
                this.loadSaves();
                this.selectedWorld = -1;
            }
            this.mc.displayScreen(this);
        }
    }

    @Override
    public void render(int xm, int ym, float partialTick) {
        this.worldSlotContainer.render(xm, ym, partialTick);
        this.drawStringCentered(this.font, this.stringTitle, this.width / 2, 20, 0xFFFFFF);
        super.render(xm, ym, partialTick);
    }

    class WorldSlot
    extends ScrolledSelectionList {
        public WorldSlot() {
            super(SelectWorldScreen.this.mc, SelectWorldScreen.this.width, SelectWorldScreen.this.height, 32, SelectWorldScreen.this.height - 64, 36);
        }

        @Override
        protected int getItemCount() {
            return SelectWorldScreen.this.saveList.size();
        }

        @Override
        protected void selectItem(int itemIndex, boolean doubleClicked) {
            SelectWorldScreen.this.selectedWorld = itemIndex;
            boolean flag1 = SelectWorldScreen.this.selectedWorld >= 0 && SelectWorldScreen.this.selectedWorld < this.getItemCount();
            boolean corrupted = SelectWorldScreen.this.saveList.get(itemIndex) == null || ((SaveFile)SelectWorldScreen.this.saveList.get(itemIndex)).isCorrupted();
            ((SelectWorldScreen)SelectWorldScreen.this).buttonSelect.enabled = flag1 && !corrupted;
            ((SelectWorldScreen)SelectWorldScreen.this).buttonRename.enabled = flag1 && !corrupted;
            ((SelectWorldScreen)SelectWorldScreen.this).buttonDelete.enabled = flag1;
            if (doubleClicked && flag1) {
                SelectWorldScreen.this.selectWorld(itemIndex);
            }
        }

        @Override
        protected boolean isSelectedItem(int itemIndex) {
            return itemIndex == SelectWorldScreen.this.selectedWorld;
        }

        @Override
        protected int getMaxPosition() {
            return SelectWorldScreen.this.saveList.size() * 36;
        }

        @Override
        protected void renderHoleBackground() {
            SelectWorldScreen.this.renderBackground();
        }

        @Override
        protected void renderItem(int index, int x, int y, int height, Tessellator tessellator) {
            I18n i18n = I18n.getInstance();
            SaveFile saveFile = (SaveFile)SelectWorldScreen.this.saveList.get(index);
            String s = saveFile.getDisplayName();
            if (saveFile.isCorrupted()) {
                s = TextFormatting.RED + s;
            }
            if (s == null || MathHelper.stringNullOrLengthZero(s)) {
                s = i18n.translateKeyAndFormat(SelectWorldScreen.this.stringWorld, index + 1);
            }
            String s1 = saveFile.getFileName();
            s1 = s1 + " (" + SelectWorldScreen.this.dateFormatter.format(new Date(saveFile.getLastTimePlayed()));
            long l1 = saveFile.getSizeOnDisk();
            s1 = s1 + ", " + (float)(l1 / 1024L * 100L / 1024L) / 100.0f + " MB)";
            String s2 = "";
            if (saveFile.getNeedsConversion()) {
                s2 = SelectWorldScreen.this.stringConversion + " " + s2;
            } else {
                I18n st = I18n.getInstance();
                LevelData ld = saveFile.getLevelData();
                DimensionData dd = saveFile.getDimensionData().get(0);
                if (dd == null) {
                    s2 = s2 + TextFormatting.RED + st.translateKey("gui.select_world.label.dimension_corrupted");
                } else {
                    WorldType worldType;
                    s2 = s2 + st.translateNameKey(Gamemode.gamemodesList[ld.getGamemode()].getLanguageKey());
                    if (ld.getCheatsEnabled()) {
                        s2 = s2 + " | " + st.translateKey("gui.select_world.label.cheats");
                    }
                    s2 = (worldType = dd.getWorldType()) != null ? s2 + " | " + st.translateNameKey(dd.getWorldType().getLanguageKey()) : s2 + " | " + TextFormatting.RED + st.translateKey("gui.select_world.label.unknown");
                }
            }
            SelectWorldScreen.this.drawString(SelectWorldScreen.this.font, s, x + 2, y + 1, 0xFFFFFF);
            SelectWorldScreen.this.drawString(SelectWorldScreen.this.font, s1, x + 2, y + 12, 0x808080);
            SelectWorldScreen.this.drawString(SelectWorldScreen.this.font, s2, x + 2, y + 12 + 10, 0x808080);
        }
    }
}

