/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.crafting.displays;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.guidebook.GuidebookSlot;
import net.minecraft.client.gui.guidebook.crafting.displays.RecipeDisplayAdapter;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingWithTool;
import net.minecraft.core.item.ItemStack;

public class ToolDisplayAdapter
implements RecipeDisplayAdapter<RecipeEntryCraftingWithTool> {
    @Override
    public List<GuidebookSlot> getSlots(RecipeEntryCraftingWithTool recipe, int recipeAmount, int xOffset, int yOffset) {
        ArrayList<GuidebookSlot> recipeSlots = new ArrayList<GuidebookSlot>();
        RecipeSymbol[] symbols = new RecipeSymbol[]{recipe.inputSymbol, recipe.toolToUse, null, null, new RecipeSymbol(recipe.output)};
        for (int i = 0; i < 4; ++i) {
            int x = 13 + 18 * (i % 2) + xOffset;
            int y = 10 + 18 * (i / 2 + recipeAmount * 3) + yOffset;
            GuidebookSlot slot = symbols[i] == recipe.toolToUse ? new ToolGuidebookSlot(i, x, y, symbols[i], false, recipe) : new GuidebookSlot(i, x, y, symbols[i], false, recipe);
            recipeSlots.add(slot);
        }
        int centerY = (((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 1))).y + ((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 3))).y) / 2;
        recipeSlots.add(new GuidebookSlot(symbols.length - 1, 81 + xOffset, centerY, symbols[4], false, recipe).setAsOutput());
        return recipeSlots;
    }

    public static class ToolGuidebookSlot
    extends GuidebookSlot {
        public ToolGuidebookSlot(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryBase<?, ?, ?> recipe) {
            super(id, x, y, symbol, discovered, recipe);
        }

        @Override
        public void showRandomItem() {
            Random r = new Random();
            if (this.symbol != null && this.symbol.getItemGroup() != null) {
                List<ItemStack> list = this.symbol.resolve();
                ItemStack newItem = list.get(r.nextInt(list.size()));
                if (list.size() > 1) {
                    while (newItem == this.item) {
                        newItem = list.get(r.nextInt(list.size()));
                    }
                }
                this.item = newItem;
            }
            this.item.setMetadata(r.nextInt(this.item.getMaxDamage()));
        }
    }
}

