/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories;

import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.ModelViewerScreen;
import net.minecraft.client.gui.modelviewer.categories.ModelViewerCategory;
import net.minecraft.client.gui.modelviewer.categories.entries.block.BasicBlockEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.block.BlockEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.block.JarEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.block.MobSpawnerEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.block.SignEntry;
import net.minecraft.client.gui.modelviewer.elements.TextCycleElement;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.chunk.DisplayChunk;

public class BlockCategory
extends ModelViewerCategory {
    public HashMap<Block, BlockEntry> entryHashMap = new HashMap();
    public TextCycleElement<Integer> blockIdTextField;
    public TextCycleElement<Integer> blockMetaTextField;

    public BlockCategory(ModelViewerScreen modelViewer) {
        super(modelViewer);
        this.createEntries();
    }

    public void createEntries() {
        for (Block block : Block.blocksList) {
            if (block == null) continue;
            this.entryHashMap.put(block, new BasicBlockEntry(block));
        }
        this.entryHashMap.put(Blocks.SIGN_WALL_PLANKS_OAK, new SignEntry(Blocks.SIGN_WALL_PLANKS_OAK));
        this.entryHashMap.put(Blocks.SIGN_POST_PLANKS_OAK, new SignEntry(Blocks.SIGN_POST_PLANKS_OAK));
        this.entryHashMap.put(Blocks.MOBSPAWNER, new MobSpawnerEntry());
        this.entryHashMap.put(Blocks.JAR_GLASS, new JarEntry());
    }

    @Override
    public String getCategoryNameKey() {
        return "model.category.block.name";
    }

    @Override
    public String getCurrentDisplayInfo(I18n translator) {
        Block displayBlock = Block.getBlock(DisplayChunk.displayBlockId);
        String name = "None";
        if (displayBlock != null) {
            name = I18n.getInstance().translateNameKey(displayBlock.getKey());
            ItemStack[] nameStack = displayBlock.getBreakResult(this.mc.theWorld, EnumDropCause.PICK_BLOCK, DisplayChunk.displayBlockPosX, DisplayChunk.displayBlockPosY, DisplayChunk.displayBlockPosZ, DisplayChunk.displayBlockMeta, DisplayChunk.displayBlockEntity);
            if (nameStack != null && nameStack.length > 0) {
                name = nameStack[0].getDisplayName();
            }
        }
        return translator.translateKeyAndFormat("model.category.block.info", name);
    }

    @Override
    public void addContextButtons(List<ButtonElement> buttonList) {
        List<ButtonElement> list;
        ButtonElement lastButton = buttonList.get(buttonList.size() - 1);
        this.modelViewer.buttonNextEntry.enabled = false;
        this.modelViewer.buttonPrevEntry.enabled = false;
        boolean wasFocused = false;
        if (this.blockIdTextField != null) {
            wasFocused = this.blockIdTextField.textField.isFocused;
        }
        this.blockIdTextField = new TextCycleElement<Integer>((Screen)this.modelViewer, this.mc.font, this.modelViewer.width - 120, lastButton.yPosition + 21, 120, 20, Integer.valueOf(DisplayChunk.displayBlockId)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return ModelViewerScreen.cycleBlockId(current, offset);
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = MathHelper.clamp(Integer.parseInt(s), 0, Block.blocksList.length);
                    if (Block.getBlock(id) != null) {
                        return id;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return DisplayChunk.displayBlockId;
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        this.blockIdTextField.textField.setFocused(wasFocused);
        this.blockIdTextField.textField.setPrefaceText("ID: ");
        this.blockIdTextField.textField.setPlaceholder("Block ID");
        this.blockIdTextField.setOnValueChanged(() -> this.setDisplayBlock(this.blockIdTextField.getCurrentElement(), 0));
        buttonList.add(this.blockIdTextField);
        wasFocused = false;
        if (this.blockMetaTextField != null) {
            wasFocused = this.blockMetaTextField.textField.isFocused;
        }
        this.blockMetaTextField = new TextCycleElement<Integer>((Screen)this.modelViewer, this.mc.font, this.modelViewer.width - 120, this.blockIdTextField.yPosition + 21, 120, 20, Integer.valueOf(0)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return current + offset & 0xFF;
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int meta = Integer.parseInt(s);
                    return MathHelper.clamp(meta, 0, 255);
                }
                catch (Exception exception) {
                    return DisplayChunk.displayBlockMeta;
                }
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        this.blockMetaTextField.textField.setFocused(wasFocused);
        this.blockMetaTextField.textField.setPlaceholder("Meta");
        this.blockMetaTextField.textField.setPrefaceText("Meta: ");
        this.blockMetaTextField.setOnValueChanged(() -> this.setDisplayBlock(DisplayChunk.displayBlockId, this.blockMetaTextField.getCurrentElement()));
        buttonList.add(this.blockMetaTextField);
        int yPos = this.blockMetaTextField.yPosition + 21;
        int xPos = this.modelViewer.width;
        BlockEntry entry = this.entryHashMap.get(Block.getBlock(DisplayChunk.displayBlockId));
        if (entry != null && (list = entry.getEntryButtons(this.mc, this.modelViewer, this.mc.theWorld, DisplayChunk.displayBlockMeta)) != null) {
            for (ButtonElement button : list) {
                button.setX(button.getX() + xPos);
                button.setY(button.getY() + yPos);
            }
            buttonList.addAll(list);
        }
    }

    @Override
    public void cycleCategoryEntry(int offset) {
    }

    @Override
    public void onOpen() {
        this.setDisplayBlock(1, 0);
    }

    @Override
    public void onClose() {
        this.setDisplayBlock(0, 0);
    }

    @Override
    public void onTick() {
        BlockEntry entry = this.entryHashMap.get(Block.getBlock(DisplayChunk.displayBlockId));
        if (entry != null) {
            entry.onTick(this.mc.theWorld, DisplayChunk.displayBlockMeta);
        }
        this.mc.theWorld.loadedEntityList.removeIf(entity -> entity instanceof ItemEntity);
    }

    public void setDisplayBlock(int id, int meta) {
        Block displayBlock = Block.blocksList[DisplayChunk.displayBlockId];
        BlockEntry entry = this.entryHashMap.get(Block.getBlock(DisplayChunk.displayBlockId));
        int _id = DisplayChunk.displayBlockId;
        int _meta = DisplayChunk.displayBlockMeta;
        if (displayBlock != null && _id != id) {
            displayBlock.onBlockRemoved(this.mc.theWorld, (int)this.mc.thePlayer.x, (int)this.mc.thePlayer.y, (int)this.mc.thePlayer.z, _meta);
        }
        if (entry != null) {
            entry.onClose(this.mc.theWorld, DisplayChunk.displayBlockMeta);
        }
        DisplayChunk.displayBlockPosX = (int)this.mc.thePlayer.x;
        DisplayChunk.displayBlockPosY = (int)this.mc.thePlayer.y;
        DisplayChunk.displayBlockPosZ = (int)this.mc.thePlayer.z;
        DisplayChunk.displayBlockId = id;
        DisplayChunk.displayBlockMeta = meta;
        displayBlock = Block.blocksList[id];
        if (displayBlock != null && _id != id) {
            entry = this.entryHashMap.get(Block.getBlock(DisplayChunk.displayBlockId));
            displayBlock.onBlockPlacedByWorld(this.mc.theWorld, (int)this.mc.thePlayer.x, (int)this.mc.thePlayer.y, (int)this.mc.thePlayer.z);
            if (entry != null) {
                entry.onOpen(this.mc.theWorld, DisplayChunk.displayBlockMeta);
            }
        }
        if (_id != id) {
            this.modelViewer.init();
        }
        this.mc.particleEngine.setWorld(this.mc.theWorld);
        this.mc.renderGlobal.loadRenderers();
    }
}

