/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.BedBlock;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;

public class BedBlockModel<T extends Block>
extends StandardBlockModel<T> {
    protected IconCoordinate underTexture = TextureRegistry.getTexture("minecraft:block/planks_oak");

    public BedBlockModel(Block block) {
        super(block);
        this.atlasIndices[0] = TextureRegistry.getTexture("minecraft:block/bed_foot_front");
        this.atlasIndices[1] = TextureRegistry.getTexture("minecraft:block/bed_foot_side");
        this.atlasIndices[2] = TextureRegistry.getTexture("minecraft:block/bed_foot_top");
        this.atlasIndices[3] = TextureRegistry.getTexture("minecraft:block/bed_head_front");
        this.atlasIndices[4] = TextureRegistry.getTexture("minecraft:block/bed_head_side");
        this.atlasIndices[5] = TextureRegistry.getTexture("minecraft:block/bed_head_top");
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        int f17;
        this.block.setBlockBoundsBasedOnState(BedBlockModel.renderBlocks.blockAccess, x, y, z);
        BedBlockModel.renderBlocks.enableAO = true;
        BedBlockModel.renderBlocks.cache.setupCache(this.block, BedBlockModel.renderBlocks.blockAccess, x, y, z);
        int meta = BedBlockModel.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        int direction = BedBlock.getDirection(meta);
        boolean isFootOfBed = BedBlock.isBlockFootOfBed(meta);
        double minY = this.block.minY;
        this.block.minY += 0.1875;
        this.renderSide(tessellator, this.block, x, y, z, 1.0f, 1.0f, 1.0f, Side.BOTTOM, meta);
        this.block.minY = minY;
        if (direction == 0) {
            BedBlockModel.renderBlocks.uvRotateTop = 1;
        } else if (direction == 2) {
            BedBlockModel.renderBlocks.uvRotateTop = 2;
        } else if (direction == 1) {
            BedBlockModel.renderBlocks.uvRotateTop = 3;
        }
        this.renderSide(tessellator, this.block, x, y, z, Side.TOP, meta);
        BedBlockModel.renderBlocks.uvRotateTop = 0;
        int n = f17 = isFootOfBed ? BedBlock.headOfBedMap[BedBlock.footToHeadMap[direction]] : BedBlock.headOfBedMap[direction];
        if (f17 != 2 && (BedBlockModel.renderBlocks.renderAllFaces || this.shouldSideBeRendered(BedBlockModel.renderBlocks.blockAccess, x, y, z - 1, 2))) {
            BedBlockModel.renderBlocks.flipTexture = direction == 3;
            this.renderSide(tessellator, this.block, x, y, z, Side.NORTH, meta);
        }
        if (f17 != 3 && (BedBlockModel.renderBlocks.renderAllFaces || this.shouldSideBeRendered(BedBlockModel.renderBlocks.blockAccess, x, y, z + 1, 3))) {
            BedBlockModel.renderBlocks.flipTexture = direction == 1;
            this.renderSide(tessellator, this.block, x, y, z, Side.SOUTH, meta);
        }
        if (f17 != 4 && (BedBlockModel.renderBlocks.renderAllFaces || this.shouldSideBeRendered(BedBlockModel.renderBlocks.blockAccess, x - 1, y, z, 4))) {
            BedBlockModel.renderBlocks.flipTexture = direction == 2;
            this.renderSide(tessellator, this.block, x, y, z, Side.WEST, meta);
        }
        if (f17 != 5 && (BedBlockModel.renderBlocks.renderAllFaces || this.shouldSideBeRendered(BedBlockModel.renderBlocks.blockAccess, x + 1, y, z, 5))) {
            BedBlockModel.renderBlocks.flipTexture = direction == 0;
            this.renderSide(tessellator, this.block, x, y, z, Side.EAST, meta);
        }
        this.resetRenderBlocks();
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (side == Side.BOTTOM) {
            return this.underTexture;
        }
        int k = BedBlock.getDirection(data);
        int l = BedBlock.bedDirection[k][side.getId()];
        if (BedBlock.isBlockFootOfBed(data)) {
            if (l == 2) {
                return this.atlasIndices[3];
            }
            if (l == 5 || l == 4) {
                return this.atlasIndices[4];
            }
            return this.atlasIndices[5];
        }
        if (l == 3) {
            return this.atlasIndices[0];
        }
        if (l == 5 || l == 4) {
            return this.atlasIndices[1];
        }
        return this.atlasIndices[2];
    }
}

