/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.piston.PistonHeadBlock;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import org.jetbrains.annotations.Nullable;

public class PistonHeadBlockModel
extends StandardBlockModel<PistonHeadBlock> {
    protected IconCoordinate pistonSide;
    protected IconCoordinate pistonDry = TextureRegistry.getTexture("minecraft:block/piston_face");
    protected IconCoordinate pistonSticky = TextureRegistry.getTexture("minecraft:block/piston_face_sticky");
    protected IconCoordinate pistonSteel = TextureRegistry.getTexture("minecraft:block/piston_face_steel");
    @Nullable
    public IconCoordinate faceTextureOverride;
    protected final double headThickness;

    public PistonHeadBlockModel(Block block, IconCoordinate pistonSide) {
        this(block, pistonSide, 0.25);
    }

    public PistonHeadBlockModel(Block block, IconCoordinate pistonSide, double headThickness) {
        super(block);
        this.pistonSide = pistonSide;
        this.headThickness = headThickness;
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        ((PistonHeadBlock)this.block).setBlockBoundsBasedOnState(PistonHeadBlockModel.renderBlocks.blockAccess, x, y, z);
        return this.renderPistonHead(tessellator, (PistonHeadBlock)this.block, x, y, z, true);
    }

    public void renderPistonHeadNoCulling(Tessellator tessellator, PistonHeadBlock block, int x, int y, int z, boolean flag) {
        PistonHeadBlockModel.renderBlocks.renderAllFaces = true;
        this.renderPistonHead(tessellator, block, x, y, z, flag);
        PistonHeadBlockModel.renderBlocks.renderAllFaces = false;
    }

    public void setFaceTextureOverride(@Nullable IconCoordinate faceTexture) {
        this.faceTextureOverride = faceTexture;
    }

    protected boolean renderPistonHead(Tessellator tessellator, PistonHeadBlock block, int x, int y, int z, boolean flag) {
        int metadata = PistonHeadBlockModel.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        Direction direction = PistonHeadBlock.getDirectionFromMeta(metadata);
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            tessellator.setLightmapCoord(block.getLightmapCoord(PistonHeadBlockModel.renderBlocks.blockAccess, x, y, z));
        } else {
            brightness = this.getBlockBrightness(PistonHeadBlockModel.renderBlocks.blockAccess, x, y, z);
        }
        float f1 = flag ? 1.0f : 0.5f;
        double width = flag ? 1.0 : 0.5;
        switch (direction) {
            case DOWN: {
                PistonHeadBlockModel.renderBlocks.uvRotateEast = 3;
                PistonHeadBlockModel.renderBlocks.uvRotateWest = 3;
                PistonHeadBlockModel.renderBlocks.uvRotateSouth = 3;
                PistonHeadBlockModel.renderBlocks.uvRotateNorth = 3;
                block.setBlockBounds(0.0, 0.0, 0.0, 1.0, this.headThickness, 1.0);
                this.renderStandardBlock(tessellator, block, x, y, z);
                this.renderHeadTopBottom(tessellator, (float)x + 0.375f, (float)x + 0.625f, (double)y + this.headThickness, (double)y + this.headThickness + (double)f1, (float)z + 0.625f, (float)z + 0.625f, brightness * 0.8f, width);
                this.renderHeadTopBottom(tessellator, (float)x + 0.625f, (float)x + 0.375f, (double)y + this.headThickness, (double)y + this.headThickness + (double)f1, (float)z + 0.375f, (float)z + 0.375f, brightness * 0.8f, width);
                this.renderHeadTopBottom(tessellator, (float)x + 0.375f, (float)x + 0.375f, (double)y + this.headThickness, (double)y + this.headThickness + (double)f1, (float)z + 0.375f, (float)z + 0.625f, brightness * 0.6f, width);
                this.renderHeadTopBottom(tessellator, (float)x + 0.625f, (float)x + 0.625f, (double)y + this.headThickness, (double)y + this.headThickness + (double)f1, (float)z + 0.625f, (float)z + 0.375f, brightness * 0.6f, width);
                break;
            }
            case UP: {
                block.setBlockBounds(0.0, 1.0 - this.headThickness, 0.0, 1.0, 1.0, 1.0);
                this.renderStandardBlock(tessellator, block, x, y, z);
                this.renderHeadTopBottom(tessellator, (float)x + 0.375f, (float)x + 0.625f, (double)y - this.headThickness + 1.0 - (double)f1, (double)y - this.headThickness + 1.0, (float)z + 0.625f, (float)z + 0.625f, brightness * 0.8f, width);
                this.renderHeadTopBottom(tessellator, (float)x + 0.625f, (float)x + 0.375f, (double)y - this.headThickness + 1.0 - (double)f1, (double)y - this.headThickness + 1.0, (float)z + 0.375f, (float)z + 0.375f, brightness * 0.8f, width);
                this.renderHeadTopBottom(tessellator, (float)x + 0.375f, (float)x + 0.375f, (double)y - this.headThickness + 1.0 - (double)f1, (double)y - this.headThickness + 1.0, (float)z + 0.375f, (float)z + 0.625f, brightness * 0.6f, width);
                this.renderHeadTopBottom(tessellator, (float)x + 0.625f, (float)x + 0.625f, (double)y - this.headThickness + 1.0 - (double)f1, (double)y - this.headThickness + 1.0, (float)z + 0.625f, (float)z + 0.375f, brightness * 0.6f, width);
                break;
            }
            case NORTH: {
                PistonHeadBlockModel.renderBlocks.uvRotateSouth = 1;
                PistonHeadBlockModel.renderBlocks.uvRotateNorth = 2;
                block.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, this.headThickness);
                this.renderStandardBlock(tessellator, block, x, y, z);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.375f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.375f, (double)z + this.headThickness, (double)z + this.headThickness + (double)f1, brightness * 0.6f, width);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.625f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.625f, (double)z + this.headThickness, (double)z + this.headThickness + (double)f1, brightness * 0.6f, width);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.375f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.375f, (double)z + this.headThickness, (double)z + this.headThickness + (double)f1, brightness * 0.5f, width);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.625f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.625f, (double)z + this.headThickness, (double)z + this.headThickness + (double)f1, brightness, width);
                break;
            }
            case SOUTH: {
                PistonHeadBlockModel.renderBlocks.uvRotateSouth = 2;
                PistonHeadBlockModel.renderBlocks.uvRotateNorth = 1;
                PistonHeadBlockModel.renderBlocks.uvRotateTop = 3;
                PistonHeadBlockModel.renderBlocks.uvRotateBottom = 3;
                block.setBlockBounds(0.0, 0.0, 1.0 - this.headThickness, 1.0, 1.0, 1.0);
                this.renderStandardBlock(tessellator, block, x, y, z);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.375f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.375f, (double)z - this.headThickness + 1.0 - (double)f1, (double)z - this.headThickness + 1.0, brightness * 0.6f, width);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.625f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.625f, (double)z - this.headThickness + 1.0 - (double)f1, (double)z - this.headThickness + 1.0, brightness * 0.6f, width);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.375f, (float)x + 0.625f, (float)y + 0.375f, (float)y + 0.375f, (double)z - this.headThickness + 1.0 - (double)f1, (double)z - this.headThickness + 1.0, brightness * 0.5f, width);
                this.renderHeadNorthSouth(tessellator, (float)x + 0.625f, (float)x + 0.375f, (float)y + 0.625f, (float)y + 0.625f, (double)z - this.headThickness + 1.0 - (double)f1, (double)z - this.headThickness + 1.0, brightness, width);
                break;
            }
            case WEST: {
                PistonHeadBlockModel.renderBlocks.uvRotateEast = 1;
                PistonHeadBlockModel.renderBlocks.uvRotateWest = 2;
                PistonHeadBlockModel.renderBlocks.uvRotateTop = 2;
                PistonHeadBlockModel.renderBlocks.uvRotateBottom = 1;
                block.setBlockBounds(0.0, 0.0, 0.0, this.headThickness, 1.0, 1.0);
                this.renderStandardBlock(tessellator, block, x, y, z);
                this.renderHeadEastWest(tessellator, (double)x + this.headThickness, (double)x + this.headThickness + (double)f1, (float)y + 0.375f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.375f, brightness * 0.5f, width);
                this.renderHeadEastWest(tessellator, (double)x + this.headThickness, (double)x + this.headThickness + (double)f1, (float)y + 0.625f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.625f, brightness, width);
                this.renderHeadEastWest(tessellator, (double)x + this.headThickness, (double)x + this.headThickness + (double)f1, (float)y + 0.375f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.375f, brightness * 0.6f, width);
                this.renderHeadEastWest(tessellator, (double)x + this.headThickness, (double)x + this.headThickness + (double)f1, (float)y + 0.625f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.625f, brightness * 0.6f, width);
                break;
            }
            case EAST: {
                PistonHeadBlockModel.renderBlocks.uvRotateEast = 2;
                PistonHeadBlockModel.renderBlocks.uvRotateWest = 1;
                PistonHeadBlockModel.renderBlocks.uvRotateTop = 1;
                PistonHeadBlockModel.renderBlocks.uvRotateBottom = 2;
                block.setBlockBounds(1.0 - this.headThickness, 0.0, 0.0, 1.0, 1.0, 1.0);
                this.renderStandardBlock(tessellator, block, x, y, z);
                this.renderHeadEastWest(tessellator, (double)x - this.headThickness + 1.0 - (double)f1, (double)x - this.headThickness + 1.0, (float)y + 0.375f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.375f, brightness * 0.5f, width);
                this.renderHeadEastWest(tessellator, (double)x - this.headThickness + 1.0 - (double)f1, (double)x - this.headThickness + 1.0, (float)y + 0.625f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.625f, brightness, width);
                this.renderHeadEastWest(tessellator, (double)x - this.headThickness + 1.0 - (double)f1, (double)x - this.headThickness + 1.0, (float)y + 0.375f, (float)y + 0.625f, (float)z + 0.375f, (float)z + 0.375f, brightness * 0.6f, width);
                this.renderHeadEastWest(tessellator, (double)x - this.headThickness + 1.0 - (double)f1, (double)x - this.headThickness + 1.0, (float)y + 0.625f, (float)y + 0.375f, (float)z + 0.625f, (float)z + 0.625f, brightness * 0.6f, width);
            }
        }
        this.resetRenderBlocks();
        block.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return true;
    }

    private void renderHeadTopBottom(Tessellator tessellator, double xMin, double xMax, double yMin, double yMax, double zMin, double zMax, float brightness, double width) {
        IconCoordinate i = this.pistonSide;
        if (PistonHeadBlockModel.renderBlocks.overrideBlockTexture != null) {
            i = PistonHeadBlockModel.renderBlocks.overrideBlockTexture;
        }
        double uMin = i.getIconUMin();
        double vMin = i.getIconVMin();
        double uMax = i.getSubIconU(width);
        double vMax = i.getSubIconV(0.25);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        tessellator.addVertexWithUV(xMin, yMax, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMin, yMin, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yMin, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yMax, zMax, uMax, vMax);
    }

    private void renderHeadNorthSouth(Tessellator tessellator, double xMin, double xMax, double yMin, double yMax, double zMin, double zMax, float brightness, double width) {
        IconCoordinate i = this.pistonSide;
        if (PistonHeadBlockModel.renderBlocks.overrideBlockTexture != null) {
            i = PistonHeadBlockModel.renderBlocks.overrideBlockTexture;
        }
        double uMin = i.getIconUMin();
        double vMin = i.getIconVMin();
        double uMax = i.getSubIconU(width);
        double vMax = i.getSubIconV(0.25);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        tessellator.addVertexWithUV(xMin, yMin, zMax, uMax, vMin);
        tessellator.addVertexWithUV(xMin, yMin, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yMax, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yMax, zMax, uMax, vMax);
    }

    private void renderHeadEastWest(Tessellator tessellator, double xMin, double xMax, double yMin, double yMax, double zMin, double zMax, float brightness, double width) {
        IconCoordinate i = this.pistonSide;
        if (PistonHeadBlockModel.renderBlocks.overrideBlockTexture != null) {
            i = PistonHeadBlockModel.renderBlocks.overrideBlockTexture;
        }
        double uMin = i.getIconUMin();
        double vMin = i.getIconVMin();
        double uMax = i.getSubIconU(width);
        double vMax = i.getSubIconV(0.25);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        tessellator.addVertexWithUV(xMax, yMin, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMin, yMin, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yMax, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yMax, zMax, uMax, vMax);
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        boolean isSteel;
        Direction direction = PistonHeadBlock.getDirectionFromMeta(data);
        if (side.getDirection() == direction) {
            if (this.faceTextureOverride != null) {
                return this.faceTextureOverride;
            }
            switch (PistonHeadBlock.getPistonType(data)) {
                case 0: {
                    return this.pistonDry;
                }
                case 1: {
                    return this.pistonSticky;
                }
                case 2: {
                    return this.pistonSteel;
                }
            }
        }
        boolean bl = isSteel = this.block == Blocks.PISTON_HEAD_STEEL;
        return side.getDirection() != direction.getOpposite() ? this.pistonSide : (isSteel ? this.pistonSteel : this.pistonDry);
    }
}

