/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class FenceGateBlock
extends Block
implements IPaintable {
    public FenceGateBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.wood);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        if (FenceGateBlock.func_35291_d(l)) {
            return null;
        }
        return this.getAABBFromMeta(l).grow(0.0, 0.25, 0.0).move(x, (float)y + 0.25f, z);
    }

    private AABB getAABBFromMeta(int meta) {
        if (FenceGateBlock.func_35290_f(meta) == 3 || FenceGateBlock.func_35290_f(meta) == 1) {
            return AABB.getTemporaryBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
        }
        return AABB.getTemporaryBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return this.getAABBFromMeta(world.getBlockMetadata(x, y, z)).move(x, y, z);
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        AABB aabb = this.getAABBFromMeta(world.getBlockMetadata(x, y, z));
        this.minX = aabb.minX;
        this.minY = aabb.minY;
        this.minZ = aabb.minZ;
        this.maxX = aabb.maxX;
        this.maxY = aabb.maxY;
        this.maxZ = aabb.maxZ;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, Side side, Mob mob, double sideHeight) {
        int directionmeta = mob.getHorizontalPlacementDirection(side).getHorizontalIndex();
        int colormeta = world.getBlockMetadata(x, y, z);
        world.setBlockMetadataWithNotify(x, y, z, directionmeta | colormeta & 0xF0);
    }

    @Override
    public void onBlockLeftClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        if (!Item.hasTag(player.getCurrentEquippedItem(), ItemTags.PREVENT_LEFT_CLICK_INTERACTIONS)) {
            this.onBlockRightClicked(world, x, y, z, player, null, 0.0, 0.0);
        }
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        int l = world.getBlockMetadata(x, y, z);
        if (FenceGateBlock.func_35291_d(l)) {
            world.setBlockMetadataWithNotify(x, y, z, l & 0xFFFFFFFB);
        } else {
            int i1 = (MathHelper.floor((double)(player.yRot * 4.0f / 360.0f) + 0.5) & 3) % 4;
            int j1 = FenceGateBlock.func_35290_f(l);
            if (j1 == (i1 + 2) % 4) {
                l = l & 0xF0 | i1;
            }
            world.setBlockMetadataWithNotify(x, y, z, l | 4);
        }
        if (Math.random() < 0.5) {
            world.playSoundEffect(player, SoundCategory.WORLD_SOUNDS, x, y, z, "random.door_open", 1.0f, 1.0f);
        } else {
            world.playSoundEffect(player, SoundCategory.WORLD_SOUNDS, x, y, z, "random.door_close", 1.0f, 1.0f);
        }
        return true;
    }

    public static boolean func_35291_d(int i) {
        return (i & 4) != 0;
    }

    public static int func_35290_f(int i) {
        return i & 3;
    }

    @Override
    public void setColor(World world, int x, int y, int z, DyeColor color) {
        int meta = world.getBlockMetadata(x, y, z);
        world.setBlockAndMetadata(x, y, z, Blocks.FENCE_GATE_PLANKS_OAK_PAINTED.id, meta);
        ((IPaintable)((Object)Blocks.FENCE_GATE_PLANKS_OAK_PAINTED)).setColor(world, x, y, z, color);
    }
}

