/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public abstract class FullRotatableBlock
extends Block {
    public FullRotatableBlock(String translationKey, String namespaceId, int id, Material material) {
        super(translationKey, namespaceId, id, material);
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, Side side, Mob mob, double sideHeight) {
        Direction direction = mob.getPlacementDirection(side).getOpposite();
        world.setBlockMetadataWithNotify(x, y, z, FullRotatableBlock.directionToMeta(direction));
    }

    public static int directionToMeta(Direction direction) {
        return direction.getId() & 7;
    }

    public static Direction metaToDirection(int meta) {
        return Direction.getDirectionById(meta & 7);
    }
}

