/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.EntityBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.JukeboxBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class JukeboxBlock
extends EntityBlock {
    public JukeboxBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.wood);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (world.getBlockMetadata(x, y, z) == 0) {
            return false;
        }
        this.ejectRecord(world, x, y, z);
        return true;
    }

    public void playRecord(World world, int i, int j, int k, int l) {
        if (!world.isClientSide) {
            JukeboxBlockEntity tileentityrecordplayer = (JukeboxBlockEntity)world.getBlockEntity(i, j, k);
            tileentityrecordplayer.record = l;
            tileentityrecordplayer.setChanged();
            world.setBlockMetadataWithNotify(i, j, k, 1);
        }
    }

    public void ejectRecord(World world, int i, int j, int k) {
        if (world.isClientSide) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(i, j, k);
        blockEntity.dropContents(world, i, j, k);
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return new JukeboxBlockEntity();
    }
}

