/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class PressurePlateBlock
extends Block {
    private final Class<? extends Entity> triggerMobClass;

    public PressurePlateBlock(String key, String namespaceId, int id, Class<? extends Entity> mobType, Material material) {
        super(key, namespaceId, id, material);
        this.triggerMobClass = mobType;
        this.setTicking(true);
        float pixel = 0.0625f;
        this.setBlockBounds(pixel, 0.0, pixel, 1.0f - pixel, pixel / 2.0f, 1.0f - pixel);
    }

    @Override
    public int tickDelay() {
        return 20;
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z) || world.isBlockNormalCube(x, y + 1, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean flag;
        boolean bl = flag = !this.canPlaceBlockAt(world, x, y, z);
        if (flag) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null, null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        if (this.isPressed(world.getBlockMetadata(x, y, z))) {
            this.updateState(world, x, y, z);
        }
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (world.isClientSide) {
            return;
        }
        if (!this.isPressed(world.getBlockMetadata(x, y, z))) {
            this.updateState(world, x, y, z);
        }
    }

    private void updateState(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        boolean isPressed = this.isPressed(meta);
        boolean isCeiling = (meta & 2) != 0;
        boolean isSteppedOn = false;
        float f = 0.125f;
        List<Entity> list = world.getEntitiesWithinAABB(this.triggerMobClass, AABB.getTemporaryBB((float)x + f, (float)y + (isCeiling ? 0.85f : 0.0f), (float)z + f, (float)(x + 1) - f, (double)y + (isCeiling ? 1.0 : 0.25), (float)(z + 1) - f));
        if (list != null && !list.isEmpty()) {
            isSteppedOn = true;
        }
        if (isSteppedOn && !isPressed) {
            world.setBlockMetadataWithNotify(x, y, z, meta | 1);
            world.notifyBlocksOfNeighborChange(x, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y + (isCeiling ? 1 : -1), z, this.id);
            world.markBlocksDirty(x, y, z, x, y, z);
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.1, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        }
        if (!isSteppedOn && isPressed) {
            world.setBlockMetadataWithNotify(x, y, z, meta & 2);
            world.notifyBlocksOfNeighborChange(x, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y + (isCeiling ? 1 : -1), z, this.id);
            world.markBlocksDirty(x, y, z, x, y, z);
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.1, (double)z + 0.5, "random.click", 0.3f, 0.5f);
        }
        if (isSteppedOn) {
            world.scheduleBlockUpdate(x, y, z, this.id, this.tickDelay());
        }
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        boolean isCeiling;
        boolean bl = isCeiling = (world.getBlockMetadata(x, y, z) & 2) != 0;
        if (this.isPressed(data)) {
            world.notifyBlocksOfNeighborChange(x, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y + (isCeiling ? 1 : -1), z, this.id);
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        boolean isPressed = this.isPressed(meta);
        boolean isCeiling = (meta & 2) != 0;
        float pixel = 0.0625f;
        if (isPressed) {
            if (isCeiling) {
                this.setBlockBounds(pixel, 0.96875, pixel, 1.0f - pixel, 1.0, 1.0f - pixel);
            } else {
                this.setBlockBounds(pixel, 0.0, pixel, 1.0f - pixel, 0.03125, 1.0f - pixel);
            }
        } else if (isCeiling) {
            this.setBlockBounds(pixel, 0.9375, pixel, 1.0f - pixel, 1.0, 1.0f - pixel);
        } else {
            this.setBlockBounds(pixel, 0.0, pixel, 1.0f - pixel, 0.0625, 1.0f - pixel);
        }
    }

    @Override
    public boolean getSignal(WorldSource worldSource, int x, int y, int z, Side side) {
        return this.isPressed(worldSource.getBlockMetadata(x, y, z));
    }

    @Override
    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        boolean isCeiling;
        int meta = world.getBlockMetadata(x, y, z);
        boolean bl = isCeiling = (meta & 2) != 0;
        if (this.isPressed(world.getBlockMetadata(x, y, z))) {
            return side == (isCeiling ? Side.BOTTOM : Side.TOP);
        }
        return false;
    }

    public boolean isPressed(int meta) {
        return (meta & 1) != 0;
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public int getPistonPushReaction(World world, int x, int y, int z) {
        return 1;
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, Side side, Mob mob, double sideHeight) {
        if (!world.canPlaceOnSurfaceOfBlock(x, y - 1, z) || side.isHorizontal() && sideHeight > 0.5 && world.isBlockNormalCube(x, y + 1, z)) {
            world.setBlockMetadata(x, y, z, world.getBlockMetadata(x, y, z) | 2);
        }
    }
}

