/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.TorchBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class RedstoneTorchBlock
extends TorchBlock {
    private final boolean torchActive;

    public RedstoneTorchBlock(String key, String namespaceId, int id, boolean isActive) {
        super(key, namespaceId, id);
        this.torchActive = isActive;
        this.setTicking(true);
    }

    @Override
    public int tickDelay() {
        return 2;
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        if (world.getBlockMetadata(x, y, z) == 0) {
            super.onBlockPlacedByWorld(world, x, y, z);
        }
        if (this.torchActive) {
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
            world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
            world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
        }
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (this.torchActive) {
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
            world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
            world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
        }
    }

    @Override
    public boolean getSignal(WorldSource worldSource, int x, int y, int z, Side side) {
        if (!this.torchActive) {
            return false;
        }
        int meta = worldSource.getBlockMetadata(x, y, z);
        if (meta == 5 && side == Side.TOP) {
            return false;
        }
        if (meta == 3 && side == Side.SOUTH) {
            return false;
        }
        if (meta == 4 && side == Side.NORTH) {
            return false;
        }
        if (meta == 1 && side == Side.EAST) {
            return false;
        }
        return meta != 2 || side != Side.WEST;
    }

    private boolean hasNeighborSignal(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 5 && world.getSignal(x, y - 1, z, Side.BOTTOM)) {
            return true;
        }
        if (meta == 3 && world.getSignal(x, y, z - 1, Side.NORTH)) {
            return true;
        }
        if (meta == 4 && world.getSignal(x, y, z + 1, Side.SOUTH)) {
            return true;
        }
        if (meta == 1 && world.getSignal(x - 1, y, z, Side.WEST)) {
            return true;
        }
        return meta == 2 && world.getSignal(x + 1, y, z, Side.EAST);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        boolean isPowered = this.hasNeighborSignal(world, x, y, z);
        if (this.torchActive) {
            if (isPowered) {
                world.setBlockAndMetadataWithNotify(x, y, z, Blocks.TORCH_REDSTONE_IDLE.id, world.getBlockMetadata(x, y, z));
            }
        } else if (!isPowered) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.TORCH_REDSTONE_ACTIVE.id, world.getBlockMetadata(x, y, z));
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        super.onNeighborBlockChange(world, x, y, z, blockId);
        world.scheduleBlockUpdate(x, y, z, this.id, this.tickDelay());
    }

    @Override
    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        if (side == Side.BOTTOM) {
            return this.getSignal(world, x, y, z, side);
        }
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        return new ItemStack[]{new ItemStack(Blocks.TORCH_REDSTONE_ACTIVE)};
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        if (!this.torchActive) {
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        double px = (double)x + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double py = (double)y + 0.7 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double pz = (double)z + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double verticalOffset = 0.22;
        double horizontalOffset = 0.27;
        int redstoneBrightness = 10;
        Color color = Colors.allRedstoneColors[10];
        if (color == null) {
            return;
        }
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        if (meta == 1) {
            world.spawnParticle("reddust", px - horizontalOffset, py + verticalOffset, pz, red, green, blue, 10);
        } else if (meta == 2) {
            world.spawnParticle("reddust", px + horizontalOffset, py + verticalOffset, pz, red, green, blue, 10);
        } else if (meta == 3) {
            world.spawnParticle("reddust", px, py + verticalOffset, pz - horizontalOffset, red, green, blue, 10);
        } else if (meta == 4) {
            world.spawnParticle("reddust", px, py + verticalOffset, pz + horizontalOffset, red, green, blue, 10);
        } else {
            world.spawnParticle("reddust", px, py, pz, red, green, blue, 10);
        }
    }
}

