/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BasketBlockEntity;
import net.minecraft.core.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.core.block.entity.ChestBlockEntity;
import net.minecraft.core.block.entity.DispenserBlockEntity;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.block.entity.FlowerJarBlockEntity;
import net.minecraft.core.block.entity.FurnaceBlockEntity;
import net.minecraft.core.block.entity.GoldMeshBlockEntity;
import net.minecraft.core.block.entity.JukeboxBlockEntity;
import net.minecraft.core.block.entity.MobSpawnerBlockEntity;
import net.minecraft.core.block.entity.NoteBlockEntity;
import net.minecraft.core.block.entity.SeatBlockEntity;
import net.minecraft.core.block.entity.SensorBlockEntity;
import net.minecraft.core.block.entity.SignBlockEntity;
import net.minecraft.core.block.entity.TrommelBlockEntity;
import net.minecraft.core.block.piston.MovingPistonBlockEntity;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.ICarriable;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BlockEntity
implements ICarriable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, Class<? extends BlockEntity>> nameToClassMap = new HashMap<String, Class<? extends BlockEntity>>();
    private static final Map<Class<? extends BlockEntity>, String> classToNameMap = new HashMap<Class<? extends BlockEntity>, String>();
    @Nullable
    public World worldObj;
    @Nullable
    public CarriedBlock carriedBlock;
    public int x;
    public int y;
    public int z;
    protected boolean tileEntityInvalid;

    private static void addMapping(Class<? extends BlockEntity> entityClass, String name) {
        if (nameToClassMap.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate id: " + name);
        }
        nameToClassMap.put(name, entityClass);
        classToNameMap.put(entityClass, name);
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        this.x = nbttagcompound.getInteger("x");
        this.y = nbttagcompound.getInteger("y");
        this.z = nbttagcompound.getInteger("z");
    }

    @Override
    public void writeToNBT(CompoundTag nbttagcompound) {
        String name = classToNameMap.get(this.getClass());
        if (name == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        nbttagcompound.putString("id", name);
        nbttagcompound.putInt("x", this.x);
        nbttagcompound.putInt("y", this.y);
        nbttagcompound.putInt("z", this.z);
    }

    public void tick() {
    }

    public static BlockEntity createAndLoadEntity(CompoundTag nbttagcompound) {
        BlockEntity blockEntity = null;
        Class<? extends BlockEntity> entityClass = nameToClassMap.get(nbttagcompound.getString("id"));
        try {
            if (entityClass != null) {
                blockEntity = entityClass.newInstance();
            }
        }
        catch (Exception exception) {
            LOGGER.error("Exception when instancing class '{}'!", (Object)entityClass.getSimpleName(), (Object)exception);
        }
        if (blockEntity != null) {
            blockEntity.readFromNBT(nbttagcompound);
        } else {
            LOGGER.warn("Skipping BlockEntity with id {}", (Object)nbttagcompound.getString("id"));
        }
        return blockEntity;
    }

    public static Class<? extends BlockEntity> getClassFromID(String id) {
        return nameToClassMap.get(id);
    }

    public int getMovedData() {
        return this.worldObj.getBlockMetadata(this.x, this.y, this.z);
    }

    public void setChanged() {
        if (this.worldObj != null) {
            this.worldObj.updateTileEntityChunkAndSendToPlayer(this.x, this.y, this.z, this);
        }
    }

    public Packet getDescriptionPacket() {
        return null;
    }

    public double getDistanceFrom(double d, double d1, double d2) {
        double d3 = (double)this.x + 0.5 - d;
        double d4 = (double)this.y + 0.5 - d1;
        double d5 = (double)this.z + 0.5 - d2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public Block getBlockType() {
        return Block.blocksList[this.worldObj.getBlockId(this.x, this.y, this.z)];
    }

    public boolean isInvalid() {
        return this.tileEntityInvalid;
    }

    public void invalidate() {
        this.tileEntityInvalid = true;
    }

    public void validate() {
        this.tileEntityInvalid = false;
    }

    @Override
    public void heldTick(World world, Entity holder) {
    }

    public void dropContents(World world, int x, int y, int z) {
    }

    @Override
    public boolean tryPlace(World world, Entity holder, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        this.x = blockX + side.getOffsetX();
        this.y = blockY + side.getOffsetY();
        this.z = blockZ + side.getOffsetZ();
        Block currentBlock = world.getBlock(this.x, this.y, this.z);
        if (currentBlock != null && !currentBlock.hasTag(BlockTags.PLACE_OVERWRITES)) {
            return false;
        }
        world.setBlockAndMetadataWithNotify(this.x, this.y, this.z, this.carriedBlock.block.id, this.carriedBlock.metadata);
        this.worldObj = world;
        this.carriedBlock = null;
        this.validate();
        world.removeBlockTileEntity(this.x, this.y, this.z);
        world.setBlockTileEntity(this.x, this.y, this.z, this);
        Block b = world.getBlock(this.x, this.y, this.z);
        if (b != null && holder instanceof Mob) {
            b.onBlockPlacedByMob(world, this.x, this.y, this.z, side, (Mob)holder, yPlaced);
        }
        return true;
    }

    @Override
    public void drop(World world, Entity holder) {
        int holderX = MathHelper.floor(holder.x);
        int holderY = MathHelper.floor(holder.y);
        int holderZ = MathHelper.floor(holder.z);
        for (int _y = holderY - 1; _y <= holderY + 1; ++_y) {
            for (int _x = holderX - 1; _x <= holderX + 1; ++_x) {
                for (int _z = holderZ - 1; _z <= holderZ + 1; ++_z) {
                    if (!this.tryPlace(world, holder, _x, _y - 1, _z, Side.TOP, 0.0, 0.0)) continue;
                    return;
                }
            }
        }
        if (world.isClientSide) {
            return;
        }
        this.dropContents(world, holderX, holderY, holderZ);
        assert (this.carriedBlock != null);
        this.carriedBlock.block.dropBlockWithCause(world, EnumDropCause.WORLD, holderX, holderY, holderZ, this.carriedBlock.metadata, this, null);
    }

    @Override
    public boolean canBeCarried(World world, Entity potentialHolder) {
        return false;
    }

    @Override
    public ICarriable pickup(World world, Entity holder) {
        Block currentBlock = world.getBlock(this.x, this.y, this.z);
        int currentMeta = world.getBlockMetadata(this.x, this.y, this.z);
        world.removeBlockTileEntity(this.x, this.y, this.z);
        Chunk c = world.getChunkFromBlockCoords(this.x, this.z);
        c.setBlockIDRaw(this.x & 0xF, this.y, this.z & 0xF, 0);
        c.recalcHeightmap();
        world.notifyBlockChange(this.x, this.y, this.z, 0);
        this.worldObj = null;
        this.carriedBlock = this.getCarriedEntry(world, holder, currentBlock, currentMeta);
        return this.carriedBlock;
    }

    public CarriedBlock getCarriedEntry(World world, Entity holder, Block currentBlock, int currentMeta) {
        return new CarriedBlock(holder, currentBlock, currentMeta, this);
    }

    static {
        BlockEntity.addMapping(FurnaceBlockEntity.class, "Furnace");
        BlockEntity.addMapping(ChestBlockEntity.class, "Chest");
        BlockEntity.addMapping(JukeboxBlockEntity.class, "RecordPlayer");
        BlockEntity.addMapping(DispenserBlockEntity.class, "Trap");
        BlockEntity.addMapping(SignBlockEntity.class, "Sign");
        BlockEntity.addMapping(MobSpawnerBlockEntity.class, "MobSpawner");
        BlockEntity.addMapping(NoteBlockEntity.class, "Music");
        BlockEntity.addMapping(MovingPistonBlockEntity.class, "Piston");
        BlockEntity.addMapping(BlastFurnaceBlockEntity.class, "BlastFurnace");
        BlockEntity.addMapping(SensorBlockEntity.class, "Sensor");
        BlockEntity.addMapping(TrommelBlockEntity.class, "Trommel");
        BlockEntity.addMapping(BasketBlockEntity.class, "Basket");
        BlockEntity.addMapping(FlagBlockEntity.class, "Flag");
        BlockEntity.addMapping(SeatBlockEntity.class, "Seat");
        BlockEntity.addMapping(FlowerJarBlockEntity.class, "FlowerJar");
        BlockEntity.addMapping(GoldMeshBlockEntity.class, "MeshGold");
    }

    public static class CarriedBlock
    implements ICarriable {
        @NotNull
        public Block block;
        public int metadata;
        @NotNull
        public BlockEntity entity;
        @NotNull
        public Entity holder;
        @NotNull
        public World world;

        public CarriedBlock(@NotNull Entity holder, @NotNull Block block, int metadata, @NotNull BlockEntity entity) {
            this.holder = holder;
            this.block = block;
            this.metadata = metadata;
            this.entity = entity;
            this.world = holder.world;
        }

        protected CarriedBlock() {
        }

        @Override
        public void heldTick(World world, Entity holder) {
            this.entity.heldTick(world, holder);
        }

        @Override
        public boolean tryPlace(World world, Entity holder, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
            return this.entity.tryPlace(world, holder, blockX, blockY, blockZ, side, xPlaced, yPlaced);
        }

        @Override
        public void drop(World world, Entity holder) {
            this.entity.drop(world, holder);
        }

        @Override
        public boolean canBeCarried(World world, Entity potentialHolder) {
            return this.entity.canBeCarried(world, potentialHolder);
        }

        @Override
        public ICarriable pickup(World world, Entity holder) {
            return this.entity.pickup(world, holder);
        }

        @Override
        public void writeToNBT(CompoundTag tag) {
            CompoundTag entityTag = new CompoundTag();
            this.entity.writeToNBT(entityTag);
            tag.put("entity", entityTag);
            tag.putInt("block", this.block.id);
            tag.putShort("meta", (short)this.metadata);
            tag.putString("type", "blockEntity");
        }

        @Override
        public void readFromNBT(CompoundTag tag) {
            this.entity = BlockEntity.createAndLoadEntity(tag.getCompound("entity"));
            this.entity.carriedBlock = this;
            this.block = Objects.requireNonNull(Block.getBlock(tag.getInteger("block")));
            this.metadata = tag.getShort("meta");
        }

        public static CarriedBlock createAndLoadCarriedBlock(@NotNull Entity holder, CompoundTag tag) {
            CarriedBlock carriedBlock = new CarriedBlock();
            carriedBlock.holder = holder;
            carriedBlock.readFromNBT(tag);
            return carriedBlock;
        }
    }
}

