/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.BlockEntityDataPacket;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.world.World;

public class FlowerJarBlockEntity
extends BlockEntity {
    public int flowerInPot;

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.flowerInPot = tag.getInteger("PlantedId");
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (this.flowerInPot > 0) {
            tag.putInt("PlantedId", this.flowerInPot);
        }
    }

    @Override
    public void dropContents(World world, int x, int y, int z) {
        super.dropContents(world, x, y, z);
        if (this.flowerInPot > 0 && Block.hasTag(this.flowerInPot, BlockTags.PLANTABLE_IN_JAR)) {
            this.flowerInPot = 0;
            if (!world.isClientSide) {
                world.dropItem(x, y, z, new ItemStack(this.flowerInPot, 1, 0));
            }
        }
    }

    @Override
    public Packet getDescriptionPacket() {
        return new BlockEntityDataPacket(this);
    }
}

