/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import java.util.ArrayList;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.piston.MovingPistonBlock;
import net.minecraft.core.block.piston.PistonBaseBlock;
import net.minecraft.core.block.piston.PistonHeadBlock;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class SteelPistonBaseBlock
extends PistonBaseBlock {
    public static final double HEAD_THICKNESS_STEEL = 0.375;

    public SteelPistonBaseBlock(String key, String namespaceId, int id, int maxPushedBlocks) {
        super(key, namespaceId, id, maxPushedBlocks);
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        int data = world.getBlockMetadata(x, y, z);
        if (SteelPistonBaseBlock.isPowered(data)) {
            switch (SteelPistonBaseBlock.getDirection(data)) {
                case DOWN: {
                    this.setBlockBounds(0.0, 0.375, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case UP: {
                    this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
                    break;
                }
                case NORTH: {
                    this.setBlockBounds(0.0, 0.0, 0.375, 1.0, 1.0, 1.0);
                    break;
                }
                case SOUTH: {
                    this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.625);
                    break;
                }
                case WEST: {
                    this.setBlockBounds(0.375, 0.0, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case EAST: {
                    this.setBlockBounds(0.0, 0.0, 0.0, 0.625, 1.0, 1.0);
                }
            }
        } else {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
    }

    @Override
    public void extendEvent(World world, int x, int y, int z, int data, Direction direction) {
        ArrayList<Entity> entityList = new ArrayList<Entity>(world.getEntitiesWithinAABBExcludingEntity(null, AABB.getTemporaryBB((double)x + (double)direction.getOffsetX(), (double)y + (double)direction.getOffsetY(), (double)z + (double)direction.getOffsetZ(), (double)x + (double)direction.getOffsetX() + 1.0, (double)y + (double)direction.getOffsetY() + 1.0, (double)z + (double)direction.getOffsetZ() + 1.0)));
        for (Entity entity : entityList) {
            if (entity == null || entity.noPhysics) continue;
            double speed = 2.0;
            entity.xd += 2.0 * (double)direction.getOffsetX();
            entity.yd += 2.0 * (double)direction.getOffsetY();
            entity.zd += 2.0 * (double)direction.getOffsetZ();
            entity.fallDistance = 0.0f;
            entity.pushTime = 1.0f;
        }
        super.extendEvent(world, x, y, z, data, direction);
    }

    @Override
    public void createPistonHeadAt(World world, int x, int y, int z, int data, Direction direction) {
        world.setBlockAndMetadata(x, y, z, Blocks.PISTON_MOVING.id, PistonHeadBlock.setPistonType(2, direction.getId()));
        world.replaceBlockTileEntity(x, y, z, MovingPistonBlock.createTileEntity(Blocks.PISTON_HEAD_STEEL.id, PistonHeadBlock.setPistonType(2, direction.getId()), null, direction, true, false));
    }
}

