/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class TNTPrimedEntity
extends Entity {
    public int fuse = 0;

    public TNTPrimedEntity(World world) {
        super(world);
        this.blocksBuilding = true;
        this.setSize(0.98f, 0.98f);
        this.heightOffset = this.bbHeight / 2.0f;
    }

    public TNTPrimedEntity(World world, double d, double d1, double d2) {
        this(world);
        this.setPos(d, d1, d2);
        float f = (float)(Math.random() * Math.PI * 2.0);
        this.xd = -MathHelper.sin(f * (float)Math.PI / 180.0f) * 0.02f;
        this.yd = 0.2;
        this.zd = -MathHelper.cos(f * (float)Math.PI / 180.0f) * 0.02f;
        this.fuse = 80;
        this.xo = d;
        this.yo = d1;
        this.zo = d2;
    }

    @Override
    protected void defineSynchedData() {
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }

    @Override
    public boolean isPickable() {
        return !this.removed;
    }

    @Override
    public void tick() {
        this.checkOnWater(true);
        this.checkOnWater(true);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= 0.04;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.98;
        this.yd *= 0.98;
        this.zd *= 0.98;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
            this.yd *= -0.5;
        }
        if (this.fuse-- <= 0) {
            if (!this.world.isClientSide) {
                this.remove();
                this.world.createExplosion(null, this.x, this.y, this.z, 4.0f);
            } else {
                this.remove();
            }
        } else {
            this.world.spawnParticle("smoke", this.x, this.y + 0.5, this.z, 0.0, 0.0, 0.0, 0);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putByte("Fuse", (byte)this.fuse);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        this.fuse = tag.getByte("Fuse");
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }
}

