/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.projectile;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.item.Item;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;

public class Projectile
extends Entity {
    public Mob owner;
    protected int ticksInGround;
    protected int ticksInAir = 0;
    public int damage;
    public Item modelItem = null;
    protected float defaultGravity;
    protected float gravity;
    protected float defaultProjectileSpeed;
    protected float projectileSpeed;

    public Projectile(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
        this.initProjectile();
    }

    public Projectile(World world, Mob owner) {
        super(world);
        this.owner = owner;
        this.setSize(0.25f, 0.25f);
        this.moveTo(owner.x, owner.y + (double)owner.getHeadHeight(), owner.z, owner.yRot, owner.xRot);
        this.x -= (double)(MathHelper.cos(this.yRot / 180.0f * (float)Math.PI) * 0.16f);
        this.y -= 0.1;
        this.z -= (double)(MathHelper.sin(this.yRot / 180.0f * (float)Math.PI) * 0.16f);
        this.setPos(this.x, this.y, this.z);
        this.heightOffset = 0.0f;
        float f = 0.4f;
        this.xd = -MathHelper.sin(this.yRot / 180.0f * (float)Math.PI) * MathHelper.cos(this.xRot / 180.0f * (float)Math.PI) * f;
        this.zd = MathHelper.cos(this.yRot / 180.0f * (float)Math.PI) * MathHelper.cos(this.xRot / 180.0f * (float)Math.PI) * f;
        this.yd = -MathHelper.sin(this.xRot / 180.0f * (float)Math.PI) * f;
        this.setHeading(this.xd, this.yd, this.zd, 1.5f, 1.0f);
        this.initProjectile();
    }

    public Projectile(World world, double x, double y, double z) {
        super(world);
        this.ticksInGround = 0;
        this.setSize(0.25f, 0.25f);
        this.setPos(x, y, z);
        this.heightOffset = 0.0f;
        this.initProjectile();
    }

    @Override
    protected void defineSynchedData() {
    }

    protected void initProjectile() {
        this.damage = 0;
        this.defaultGravity = 0.03f;
        this.defaultProjectileSpeed = 0.99f;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double distance) {
        double d1 = this.bb.getSize() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
    }

    public void setHeading(double newMotionX, double newMotionY, double newMotionZ, float speed, float randomness) {
        float velocity = MathHelper.sqrt(newMotionX * newMotionX + newMotionY * newMotionY + newMotionZ * newMotionZ);
        newMotionX /= (double)velocity;
        newMotionY /= (double)velocity;
        newMotionZ /= (double)velocity;
        newMotionX += this.random.nextGaussian() * 0.0075 * (double)randomness;
        newMotionY += this.random.nextGaussian() * 0.0075 * (double)randomness;
        newMotionZ += this.random.nextGaussian() * 0.0075 * (double)randomness;
        this.xd = newMotionX *= (double)speed;
        this.yd = newMotionY *= (double)speed;
        this.zd = newMotionZ *= (double)speed;
        float f3 = MathHelper.sqrt(newMotionX * newMotionX + newMotionZ * newMotionZ);
        this.yRotO = this.yRot = (float)(Math.atan2(newMotionX, newMotionZ) * 180.0 / Math.PI);
        this.xRotO = this.xRot = (float)(Math.atan2(newMotionY, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    public void setHeadingPrecise(double newMotionX, double newMotionY, double newMotionZ, float speed) {
        float velocity = MathHelper.sqrt(newMotionX * newMotionX + newMotionY * newMotionY + newMotionZ * newMotionZ);
        newMotionX /= (double)velocity;
        newMotionY /= (double)velocity;
        newMotionZ /= (double)velocity;
        this.xd = newMotionX *= (double)speed;
        this.yd = newMotionY *= (double)speed;
        this.zd = newMotionZ *= (double)speed;
        float horizontalVelocity = MathHelper.sqrt(newMotionX * newMotionX + newMotionZ * newMotionZ);
        this.yRotO = this.yRot = (float)(Math.atan2(newMotionX, newMotionZ) * 180.0 / Math.PI);
        this.xRotO = this.xRot = (float)(Math.atan2(newMotionY, horizontalVelocity) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    @Override
    public void lerpMotion(double xd, double yd, double zd) {
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = MathHelper.sqrt(xd * xd + zd * zd);
            this.yRotO = this.yRot = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
            this.xRotO = this.xRot = (float)(Math.atan2(yd, f) * 180.0 / Math.PI);
        }
    }

    @Override
    public void tick() {
        this.gravity = this.defaultGravity;
        this.projectileSpeed = this.defaultProjectileSpeed;
        super.tick();
        ++this.ticksInAir;
        HitResult movingobjectposition = this.getHitResult();
        Vec3 oldPosition = Vec3.getTempVec3(this.x, this.y, this.z);
        Vec3 newPosition = Vec3.getTempVec3(this.x + this.xd, this.y + this.yd, this.z + this.zd);
        if (movingobjectposition != null) {
            newPosition = Vec3.getTempVec3(movingobjectposition.location.x, movingobjectposition.location.y, movingobjectposition.location.z);
        }
        if (!this.world.isClientSide) {
            Entity entity = null;
            List<Entity> list = this.world.getEntitiesWithinAABBExcludingEntity(this, this.bb.expand(this.xd, this.yd, this.zd).grow(1.0, 1.0, 1.0));
            double d = 0.0;
            for (Entity entity1 : list) {
                double d1;
                float f4;
                AABB axisalignedbb;
                HitResult movingobjectposition1;
                if (!entity1.isPickable() || entity1 == this.owner && this.ticksInAir < 5 || (movingobjectposition1 = (axisalignedbb = entity1.bb.grow(f4 = 0.3f, f4, f4)).clip(oldPosition, newPosition)) == null || !((d1 = oldPosition.distanceTo(movingobjectposition1.location)) < d) && d != 0.0) continue;
                entity = entity1;
                d = d1;
            }
            if (entity != null) {
                movingobjectposition = new HitResult(entity);
            }
        }
        if (movingobjectposition != null) {
            this.onHit(movingobjectposition);
        }
        this.afterTick();
    }

    public HitResult getHitResult() {
        Vec3 oldPosition = Vec3.getTempVec3(this.x, this.y, this.z);
        Vec3 newPosition = Vec3.getTempVec3(this.x + this.xd, this.y + this.yd, this.z + this.zd);
        return this.world.checkBlockCollisionBetweenPoints(oldPosition, newPosition);
    }

    public void onHit(HitResult hitResult) {
        if (hitResult.entity != null) {
            hitResult.entity.hurt(this.owner, this.damage, DamageType.COMBAT);
        }
        if (this.modelItem != null) {
            for (int j = 0; j < 8; ++j) {
                this.world.spawnParticle("item", this.x, this.y, this.z, 0.0, 0.0, 0.0, this.modelItem.id);
            }
        }
        this.remove();
    }

    public void afterTick() {
        this.x += this.xd;
        this.y += this.yd;
        this.z += this.zd;
        float f = MathHelper.sqrt(this.xd * this.xd + this.zd * this.zd);
        this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / Math.PI);
        this.xRot = (float)(Math.atan2(this.yd, f) * 180.0 / Math.PI);
        while (this.xRot - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.xRot - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.yRot - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.yRot - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        this.xRot = this.xRotO + (this.xRot - this.xRotO) * 0.2f;
        this.yRot = this.yRotO + (this.yRot - this.yRotO) * 0.2f;
        if (this.isInWater()) {
            this.waterTick();
        }
        this.xd *= (double)this.projectileSpeed;
        this.yd *= (double)this.projectileSpeed;
        this.zd *= (double)this.projectileSpeed;
        this.yd -= (double)this.gravity;
        this.setPos(this.x, this.y, this.z);
    }

    public void waterTick() {
        for (int k = 0; k < 4; ++k) {
            double particleDistance = 0.25;
            this.world.spawnParticle("bubble", this.x - this.xd * particleDistance, this.y - this.yd * particleDistance, this.z - this.zd * particleDistance, this.xd, this.yd, this.zd, 0);
        }
        this.projectileSpeed = 0.8f;
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }
}

