/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.core.data.gamerule.GameRule;
import net.minecraft.core.data.gamerule.GameRuleBoolean;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.GenericGameRuleArgumentType;

public class GameRuleCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder argumentBuilder = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal("gamerule").requires(CommandSource::hasAdmin);
        for (GameRule<?> gameRule : Registries.GAME_RULES) {
            RequiredArgumentBuilder gameRuleValueArgument = gameRule instanceof GameRuleBoolean ? (RequiredArgumentBuilder)RequiredArgumentBuilder.argument("value", BoolArgumentType.bool()).executes(c -> {
                ((CommandSource)c.getSource()).getWorld().getLevelData().getGameRules().setValue(gameRule, BoolArgumentType.getBool(c, "value"));
                ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.gamerule.set", gameRule.getKey(), BoolArgumentType.getBool(c, "value"));
                return 1;
            }) : (RequiredArgumentBuilder)RequiredArgumentBuilder.argument("value", GenericGameRuleArgumentType.gameRule(gameRule)).executes(c -> {
                Object o = c.getArgument("value", Object.class);
                ((CommandSource)c.getSource()).getWorld().getLevelData().getGameRules().setValue(gameRule, o);
                ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.gamerule.set", gameRule.getKey(), o);
                return 1;
            });
            argumentBuilder.then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal(gameRule.getKey()).executes(c -> {
                ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.gamerule.get", gameRule.getKey(), ((CommandSource)c.getSource()).getWorld().getGameRuleValue(gameRule));
                return 1;
            })).then(gameRuleValueArgument));
        }
        LiteralCommandNode<CommandSource> commandNode = dispatcher.register(argumentBuilder);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("gr").requires(CommandSource::hasAdmin)).redirect(commandNode));
    }
}

