/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.TimeArgumentType;
import net.minecraft.core.world.LevelListener;
import net.minecraft.core.world.World;

public class TimeCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("time").requires(CommandSource::hasAdmin)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("query").then(LiteralArgumentBuilder.literal("daytime").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            source.sendTranslatableMessage("command.commands.time.query", ((CommandSource)c.getSource()).getWorld().getWorldTime() % 24000L);
            return 1;
        }))).then(LiteralArgumentBuilder.literal("gametime").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            source.sendTranslatableMessage("command.commands.time.query", source.getWorld().getWorldTime() % Integer.MAX_VALUE);
            return 1;
        }))).then(LiteralArgumentBuilder.literal("day").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            source.sendTranslatableMessage("command.commands.time.query", source.getWorld().getWorldTime() / 24000L % Integer.MAX_VALUE);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("set").then(RequiredArgumentBuilder.argument("time", TimeArgumentType.time()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            int time = c.getArgument("time", Integer.class);
            TimeCommand.setWorldTime(source, source.getWorld(), time);
            return 1;
        }))).then(LiteralArgumentBuilder.literal("day").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            TimeCommand.setDayTime(source, source.getWorld(), 1000L);
            return 1;
        }))).then(LiteralArgumentBuilder.literal("noon").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            TimeCommand.setDayTime(source, source.getWorld(), 6000L);
            return 1;
        }))).then(LiteralArgumentBuilder.literal("night").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            TimeCommand.setDayTime(source, source.getWorld(), 13000L);
            return 1;
        }))).then(LiteralArgumentBuilder.literal("midnight").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            TimeCommand.setDayTime(source, source.getWorld(), 18000L);
            return 1;
        })))).then(LiteralArgumentBuilder.literal("add").then(RequiredArgumentBuilder.argument("time", TimeArgumentType.time()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            int time = c.getArgument("time", Integer.class);
            TimeCommand.addWorldTime(source, source.getWorld(), time);
            return 1;
        }))));
    }

    private static void setDayTime(CommandSource source, World world, long time) {
        TimeCommand.setWorldTime(source, world, world.getWorldTime() - world.getWorldTime() % 24000L + time);
    }

    private static void setWorldTime(CommandSource source, World world, long time) {
        world.setWorldTime(time);
        for (LevelListener listener : world.listeners) {
            listener.allChanged(true, true);
        }
        source.sendTranslatableMessage("command.commands.time.set", time);
    }

    private static void addWorldTime(CommandSource source, World world, long time) {
        TimeCommand.setWorldTime(source, world, world.getWorldTime() + time);
    }
}

