/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.server.util.helper.PlayerList;

public class UpdatePlayerProfilePacket
extends Packet {
    public String username;
    public String nickname;
    public UUID uuid;
    public int score;
    public byte chatColor;
    public boolean isOnline;
    public boolean isOperator;

    public UpdatePlayerProfilePacket() {
    }

    public UpdatePlayerProfilePacket(String username, String nickname, UUID uuid, int score, byte chatColor, boolean isOnline, boolean isOperator) {
        this.username = username;
        this.nickname = nickname;
        this.uuid = uuid;
        this.score = score;
        this.chatColor = chatColor;
        this.isOnline = isOnline;
        this.isOperator = isOperator;
        PlayerList.updateList();
    }

    @Override
    public void read(DataInputStream dis) throws IOException {
        this.username = UpdatePlayerProfilePacket.readString(dis, 16);
        this.nickname = UpdatePlayerProfilePacket.readString(dis, 32);
        this.uuid = UpdatePlayerProfilePacket.readUUID(dis);
        this.score = dis.readInt();
        this.chatColor = dis.readByte();
        this.isOnline = dis.readBoolean();
        this.isOperator = dis.readBoolean();
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        UpdatePlayerProfilePacket.writeString(this.username, dos);
        UpdatePlayerProfilePacket.writeString(this.nickname, dos);
        UpdatePlayerProfilePacket.writeUUID(this.uuid, dos);
        dos.writeInt(this.score);
        dos.writeByte(this.chatColor);
        dos.writeBoolean(this.isOnline);
        dos.writeBoolean(this.isOperator);
    }

    @Override
    public void handlePacket(PacketHandler packetHandler) {
        packetHandler.handleUpdatePlayerProfile(this);
    }

    @Override
    public int getEstimatedSize() {
        return 10 + this.username.length() + 4;
    }
}

