/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.container;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.menu.AbstractContainerMenu;

public class CraftingContainer
implements Container {
    private ItemStack[] items;
    private int width;
    private AbstractContainerMenu menu;

    public CraftingContainer(AbstractContainerMenu container, int width, int n) {
        int k = width * n;
        this.items = new ItemStack[k];
        this.menu = container;
        this.width = width;
    }

    @Override
    public int getContainerSize() {
        return this.items.length;
    }

    @Override
    public ItemStack getItem(int index) {
        if (index >= this.getContainerSize()) {
            return null;
        }
        return this.items[index];
    }

    public ItemStack getItemStackAt(int i, int j) {
        if (i < 0 || i >= this.width) {
            return null;
        }
        int k = i + j * this.width;
        return this.getItem(k);
    }

    public void setSlotContentsAt(int i, int j, ItemStack itemStack) {
        if (i < 0 || i >= this.width) {
            return;
        }
        int k = i + j * this.width;
        this.setItem(k, itemStack);
    }

    @Override
    public String getName() {
        return "Crafting";
    }

    @Override
    public ItemStack removeItem(int index, int takeAmount) {
        if (this.items[index] != null) {
            if (this.items[index].stackSize <= takeAmount) {
                ItemStack itemstack = this.items[index];
                this.items[index] = null;
                this.menu.slotsChanged(this);
                return itemstack;
            }
            ItemStack itemstack1 = this.items[index].splitStack(takeAmount);
            if (this.items[index].stackSize <= 0) {
                this.items[index] = null;
            }
            this.menu.slotsChanged(this);
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setItem(int index, ItemStack itemstack) {
        this.items[index] = itemstack;
        this.menu.slotsChanged(this);
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    @Override
    public void setChanged() {
        this.menu.slotsChanged(this);
    }

    @Override
    public boolean stillValid(Player entityplayer) {
        return true;
    }

    @Override
    public void sortContainer() {
    }
}

