/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type;

import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderSingleBiome;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.empty.ChunkGeneratorEmpty;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.weather.Weather;

public class WorldTypeEmpty
extends WorldType {
    public WorldTypeEmpty(WorldType.Properties properties) {
        super(properties);
    }

    public static float[] createLightRamp() {
        float[] brightnessRamp = new float[32];
        float f = 0.05f;
        for (int i = 0; i <= 31; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            if (i > 15) {
                f1 = 0.0f;
            }
            brightnessRamp[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
        return brightnessRamp;
    }

    @Override
    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderSingleBiome(Biomes.OVERWORLD_PLAINS, 1.0, 1.0, 1.0);
    }

    @Override
    public ChunkGenerator createChunkGenerator(World world) {
        return new ChunkGeneratorEmpty(world);
    }

    @Override
    public boolean isValidSpawn(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public void getInitialSpawnLocation(World world) {
        world.getLevelData().setSpawn(0, 1, 0);
    }

    @Override
    public void getRespawnLocation(World world) {
    }

    @Override
    public float getCelestialAngle(World world, long tick, float partialTick) {
        return this.getTimeOfDay(world, tick, partialTick);
    }

    @Override
    public float[] getSunriseColor(float timeOfDay, float partialTick) {
        float f4;
        float[] sunriseCol = new float[4];
        float f2 = 0.4f;
        float f3 = MathHelper.cos(timeOfDay * (float)Math.PI * 2.0f) - 0.0f;
        if (f3 >= (f4 = -0.0f) - f2 && f3 <= f4 + f2) {
            float c = (f3 - f4) / f2 * 0.5f + 0.5f;
            float a = 1.0f - (1.0f - MathHelper.sin(c * (float)Math.PI)) * 0.99f;
            a *= a;
            sunriseCol[0] = c * 0.3f + 0.7f;
            sunriseCol[1] = c * c * 0.7f + 0.2f;
            sunriseCol[2] = c * c * 0.0f + 0.2f;
            sunriseCol[3] = a;
            return sunriseCol;
        }
        return null;
    }

    @Override
    public int getSkyDarken(World world, long tick, float partialTick) {
        float f1 = this.getCelestialAngle(world, tick, partialTick);
        float f2 = 1.0f - (MathHelper.cos(f1 * (float)Math.PI * 2.0f) * 2.0f + 0.5f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float weatherOffset = 0.0f;
        Weather currentWeather = world.getCurrentWeather();
        if (currentWeather != null) {
            weatherOffset = (float)currentWeather.subtractLightLevel * world.weatherManager.getWeatherIntensity() * world.weatherManager.getWeatherPower();
        }
        return (int)(f2 * (11.0f - weatherOffset) + weatherOffset);
    }

    @Override
    public Vec3 getFogColor(World world, double x, double y, double z, float celestialAngle, float partialTick) {
        float f2 = MathHelper.cos(celestialAngle * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float r = 0.7529412f;
        float g = 0.8470588f;
        float b = 1.0f;
        return Vec3.getTempVec3(r *= f2 * 0.94f + 0.06f, g *= f2 * 0.94f + 0.06f, b *= f2 * 0.91f + 0.09f);
    }
}

