/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.wind;

import java.util.Random;
import net.minecraft.core.world.World;
import net.minecraft.core.world.noise.ImprovedNoise;
import net.minecraft.core.world.wind.WindProvider;

public class WindProviderGeneric
extends WindProvider {
    private final double perlinMax = Math.sqrt(0.75);
    private long randomSeed = -1L;
    private Random directionRandom = null;
    private Random intensityRandom = null;
    private ImprovedNoise directionNoise = null;
    private ImprovedNoise intensityNoise = null;
    private long lastSampleTime = -1L;
    private double lastDirectionSample = 0.0;
    private double lastIntensitySample = 0.0;

    private void initialize(World world) {
        if (this.randomSeed != world.getRandomSeed() || this.directionRandom == null || this.intensityRandom == null || this.directionNoise == null || this.intensityNoise == null) {
            this.randomSeed = world.getRandomSeed();
            this.directionRandom = new Random(this.randomSeed * 16237L);
            this.directionNoise = new ImprovedNoise(this.directionRandom);
            this.intensityRandom = new Random(this.randomSeed * 3183L);
            this.intensityNoise = new ImprovedNoise(this.intensityRandom);
        }
    }

    private void resample(World world) {
        if (this.lastSampleTime == world.getWorldTime()) {
            return;
        }
        this.lastSampleTime = world.getWorldTime();
        this.lastDirectionSample = this.directionNoise.getValue((float)world.getWorldTime() / 2500.0f, 0.0);
        this.lastIntensitySample = this.intensityNoise.getValue((float)world.getWorldTime() / 150.0f, 0.0);
    }

    @Override
    public float getWindDirection(World world, float x, float y, float z) {
        this.initialize(world);
        this.resample(world);
        double direction = this.lastDirectionSample;
        int avgChunkHeight = world.getChunkFromBlockCoords((int)((int)x), (int)((int)z)).averageBlockHeight;
        return (float)(direction /= this.perlinMax);
    }

    @Override
    public float getWindIntensity(World world, float x, float y, float z) {
        this.initialize(world);
        this.resample(world);
        double intensity = this.lastIntensitySample;
        intensity += this.perlinMax;
        intensity /= 2.0 * this.perlinMax;
        float yFloat = y / (float)world.getHeightBlocks();
        int avgChunkHeight = world.getChunkFromBlockCoords((int)((int)x), (int)((int)z)).averageBlockHeight;
        if (yFloat < 0.0f) {
            yFloat = 0.0f;
        }
        if (yFloat > 1.0f) {
            yFloat = 1.0f;
        }
        if ((double)yFloat < 0.4) {
            float percentage = yFloat / 0.4f;
            intensity *= (double)(0.25f * percentage);
        } else if (yFloat >= 0.4f && yFloat < 0.6f) {
            float percentage = (yFloat - 0.4f) / 0.2f;
            intensity *= (double)(0.25f + 0.5f * percentage);
        } else if (yFloat >= 0.6f) {
            float percentage = (yFloat - 0.6f) / 0.4f;
            intensity *= (double)(0.75f + 0.25f * percentage);
        }
        if (y < (float)avgChunkHeight) {
            intensity = 0.0;
        }
        return (float)intensity;
    }
}

