/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeGroup;
import net.minecraft.core.item.Items;
import net.minecraft.datagen.SmeltingGenerator;
import net.minecraft.datagen.TrommelGenerator;
import net.minecraft.datagen.WorkbenchGenerator;
import net.minecraft.datagen.recipeBuilders.RecipeBuilder;

public class RecipesGenerator {
    private static final boolean DEBUG = false;
    public static final String CORE_NAMESPACE = "minecraft";

    public static void main(String[] args) throws IOException {
        System.out.println("Generating Recipes with args: ");
        System.out.println(Arrays.toString(args));
        String outputPath = null;
        int pointer = 0;
        block8: while (pointer < args.length) {
            switch (args[pointer]) {
                case "--output": {
                    try {
                        outputPath = args[pointer + 1];
                        ++pointer;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++pointer;
                    continue block8;
                }
            }
            ++pointer;
        }
        File output = outputPath != null ? new File(outputPath) : new File("generated/recipes/");
        output.mkdirs();
        Blocks.init();
        Items.init();
        new Registries();
        WorkbenchGenerator.generate();
        RecipeBuilder.exportRecipes(new File(output, "workbench.json"), Registries.RECIPES.WORKBENCH);
        SmeltingGenerator.generate();
        RecipeBuilder.exportRecipes(new File(output, "furnace.json"), Registries.RECIPES.FURNACE);
        RecipeBuilder.exportRecipes(new File(output, "blast_furnace.json"), Registries.RECIPES.BLAST_FURNACE);
        TrommelGenerator.generate();
        RecipeBuilder.exportRecipes(new File(output, "trommel.json"), Registries.RECIPES.TROMMEL);
        System.out.println("Finished all " + Registries.RECIPES.getAllRecipes().size() + " recipes!");
    }

    public static List<String> getMissingIds(RecipeGroup recipeGroup, File referenceFile) {
        assert (referenceFile != null);
        assert (referenceFile.isFile());
        assert (referenceFile.exists());
        try {
            JsonArray entries = JsonParser.parseReader(new JsonReader(new FileReader(referenceFile))).getAsJsonArray();
            ArrayList<String> entryNames = new ArrayList<String>();
            for (JsonElement e : entries) {
                entryNames.add(e.getAsJsonObject().get("name").getAsString().replaceFirst("minecraft:" + recipeGroup.getParent().getKey(recipeGroup) + "/", ""));
            }
            for (JsonElement recipe : recipeGroup) {
                entryNames.remove(recipeGroup.getKey(recipe));
            }
            return entryNames;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

