/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.handler;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Key;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.Global;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.AESSendKeyPacket;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.net.packet.CommandManagerPacket;
import net.minecraft.core.net.packet.DisconnectPacket;
import net.minecraft.core.net.packet.GameRulePacket;
import net.minecraft.core.net.packet.LoginPacket;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PhotoModePacket;
import net.minecraft.core.net.packet.PingHandshakePacket;
import net.minecraft.core.net.packet.PlayerGamemodePacket;
import net.minecraft.core.net.packet.PreLoginPacket;
import net.minecraft.core.net.packet.RecipeSyncPacket;
import net.minecraft.core.net.packet.SetCarriedItemPacket;
import net.minecraft.core.net.packet.SetHeldObjectPacket;
import net.minecraft.core.net.packet.SetHotbarOffsetPacket;
import net.minecraft.core.net.packet.SetSpawnPositionPacket;
import net.minecraft.core.net.packet.SetTimePacket;
import net.minecraft.core.net.packet.SyncIDsPacket;
import net.minecraft.core.net.packet.UpdatePlayerProfilePacket;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.RSA;
import net.minecraft.core.util.helper.RestHandler;
import net.minecraft.core.util.helper.UUIDHelper;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;
import net.minecraft.server.net.command.ServerCommandSource;
import net.minecraft.server.net.handler.ServerPacketHandler;
import net.minecraft.server.world.WorldServer;
import org.slf4j.Logger;

public class LoginPacketHandler
extends PacketHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Random rand = new Random();
    public NetworkManager netManager;
    public boolean finishedProcessing = false;
    private final MinecraftServer mcServer;
    private int loginTimer = 0;
    private String username = null;
    private LoginPacket loginPacket = null;
    private String serverId = "";
    public static String kickMessage = null;

    public LoginPacketHandler(MinecraftServer minecraftserver, Socket socket, String s) throws IOException {
        this.mcServer = minecraftserver;
        this.netManager = new NetworkManager(socket, s, this);
        this.netManager.fakeLag = 0;
    }

    public void tryLogin() {
        if (this.loginPacket != null) {
            this.doLogin(this.loginPacket);
            this.loginPacket = null;
        }
        if (this.loginTimer++ == 600) {
            this.kickUser("Took too long to log in");
        } else {
            this.netManager.processReadPackets();
        }
    }

    public void kickUser(String s) {
        this.kickUser(s, false);
    }

    public void kickUser(String s, boolean silent) {
        try {
            if (!silent) {
                LOGGER.info("Disconnecting {}: {}", (Object)this.getUserAndIPString(), (Object)s);
            }
            this.netManager.addToSendQueue(new DisconnectPacket(s));
            this.netManager.serverShutdown();
            this.finishedProcessing = true;
        }
        catch (Exception exception) {
            LOGGER.error("Error while kicking user '{}'!", (Object)s, (Object)exception);
        }
    }

    @Override
    public void handleHandshake(PreLoginPacket preLoginPacket) {
        if (this.mcServer.onlineMode) {
            this.serverId = Long.toHexString(rand.nextLong());
            this.netManager.addToSendQueue(new PreLoginPacket(this.serverId));
        } else {
            this.netManager.addToSendQueue(new PreLoginPacket("-"));
        }
    }

    @Override
    public void handleLogin(LoginPacket loginPacket) {
        this.username = loginPacket.username;
        if (loginPacket.playerEntityIdAndProtocolVersion != 29184) {
            if (loginPacket.playerEntityIdAndProtocolVersion > 29184) {
                this.kickUser("Outdated server!");
            } else {
                this.kickUser("Outdated client!");
            }
            return;
        }
        if (!this.mcServer.onlineMode) {
            this.doLogin(loginPacket);
        } else {
            new Thread(() -> {
                try {
                    String s = LoginPacketHandler.getServerId(this);
                    URL url = new URL("http://session.minecraft.net/game/checkserver.jsp?user=" + URLEncoder.encode(loginPacket.username, "UTF-8") + "&serverId=" + URLEncoder.encode(s, "UTF-8"));
                    BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(url.openStream()));
                    String s1 = bufferedreader.readLine();
                    bufferedreader.close();
                    if (s1.equals("YES")) {
                        LoginPacketHandler.setLoginPacket(this, loginPacket);
                    } else {
                        this.kickUser("Failed to verify username!");
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Exception while trying to verify user '{}', kicking!", (Object)this.getUserAndIPString(), (Object)exception);
                    this.kickUser("Failed to verify username! [internal error " + exception + "]");
                }
            }).start();
        }
    }

    public void doLogin(LoginPacket loginPacket) {
        ServerPlayer player;
        if (this.mcServer.onlineMode) {
            UUID mojangUUID = UUIDHelper.getUUIDFromName(loginPacket.username);
            if (mojangUUID == null) {
                this.kickUser("Cannot authenticate UUID!");
                return;
            }
            if (!mojangUUID.equals(loginPacket.uuid)) {
                this.kickUser("UUID mismatch!");
                return;
            }
        }
        if ((player = this.mcServer.playerList.getPlayerForLogin(this, loginPacket.username, loginPacket.uuid)) != null) {
            this.mcServer.playerList.load(player);
            player.setWorld(this.mcServer.getDimensionWorld(player.dimension));
            LOGGER.info(this.getUserAndIPString() + " logged in with entity id " + player.id + " at (" + player.x + ", " + player.y + ", " + player.z + ")");
            WorldServer worldserver = this.mcServer.getDimensionWorld(player.dimension);
            ChunkCoordinates chunkcoordinates = worldserver.getSpawnPoint();
            ServerPacketHandler packetHandler = new ServerPacketHandler(this.mcServer, this.netManager, player);
            try {
                packetHandler.sendPacket(new LoginPacket("", new UUID(0L, 0L), player.id, worldserver.getRandomSeed(), (byte)worldserver.dimension.id, (byte)Registries.WORLD_TYPES.getNumericIdOfItem(worldserver.dimensionData.getWorldType()), NetworkManager.PACKET_DELAY, RSA.getPublicKey(RSA.RSAKeyChain.getPublic())));
                Key aesKey = AES.generateKey();
                packetHandler.sendPacket(new AESSendKeyPacket(RSA.encrypt(AES.getKey(aesKey), RSA.getPublicKey(loginPacket.publicKey))));
                AES.keyChain.put(player.username, aesKey);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            packetHandler.sendPacket(new SetSpawnPositionPacket(chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z));
            this.mcServer.playerList.func_28170_a(player, worldserver);
            this.mcServer.playerList.sendPacketToAllPlayers(new ChatPacket(TextFormatting.YELLOW + player.getDisplayName() + TextFormatting.YELLOW + " joined the game."));
            this.mcServer.playerList.sendPacketToAllPlayers(new UpdatePlayerProfilePacket(player.username, player.nickname, player.uuid, player.score, player.chatColor, true, player.isOperator()));
            if (this.mcServer.joinMessage != null && !this.mcServer.joinMessage.isEmpty()) {
                player.playerNetServerHandler.sendPacket(new ChatPacket(this.mcServer.joinMessage));
            }
            this.mcServer.playerList.playerLoggedIn(player);
            packetHandler.teleportAndRotate(player.x, player.y, player.z, player.yRot, player.xRot);
            this.mcServer.networkServer.addPlayer(packetHandler);
            this.mcServer.playerList.sendPacketToAllPlayers(new PlayerGamemodePacket(player.id, player.gamemode.getId()));
            packetHandler.sendPacket(new SetTimePacket(worldserver.getWorldTime()));
            player.func_20057_k();
            if (MinecraftServer.statsStatus) {
                RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + MinecraftServer.statsToken + "&count=" + this.mcServer.playerList.playerEntities.size());
            }
            player.playerNetServerHandler.sendPacket(new PhotoModePacket(this.mcServer.disablePhotoMode));
            player.playerNetServerHandler.sendPacket(new GameRulePacket(this.mcServer.getDimensionWorld(0).getLevelData().getGameRules()));
            player.playerNetServerHandler.sendPacket(new CommandManagerPacket(this.mcServer.getDimensionWorld(player.dimension).getCommandManager().getDispatcher(), new ServerCommandSource(this.mcServer, player), "", 0));
            player.playerNetServerHandler.sendPacket(new SetHeldObjectPacket(player.id, player.getHeldObject()));
            player.playerNetServerHandler.sendPacket(new SetHotbarOffsetPacket(player.inventory.getHotbarOffset()));
            player.playerNetServerHandler.sendPacket(new SetCarriedItemPacket(player.inventory.getCurrentItemIndex()));
            for (RecipeEntryBase<?, ?, ?> recipe : Registries.RECIPES.getAllSerializableRecipes()) {
                player.playerNetServerHandler.sendPacket(new RecipeSyncPacket(recipe, Registries.RECIPES.getAllSerializableRecipes().size()));
            }
            player.playerNetServerHandler.sendPacket(new SyncIDsPacket());
        }
        this.finishedProcessing = true;
    }

    @Override
    public void handleErrorMessage(String message, Object[] objects) {
        LOGGER.info("{} lost connection", (Object)this.getUserAndIPString());
        LOGGER.error(message, objects);
        this.finishedProcessing = true;
    }

    @Override
    public void handlePingHandshake(PingHandshakePacket packet) {
        String msg = "";
        if (packet.pingHostString.equals("MC|PingHost")) {
            msg = "\u00a71\u00000\u0000BTA " + Global.VERSION + '\u0000' + this.mcServer.motd + '\u0000' + 0 + '\u0000' + 0;
        } else if (packet.pingHostString.equals("BTAPingHost")) {
            msg = "\u00a71\u000029184\u0000" + Global.VERSION + '\u0000' + this.mcServer.motd + '\u0000' + this.mcServer.playerList.playerEntities.size() + '\u0000' + this.mcServer.maxPlayers;
        }
        this.kickUser(msg, true);
    }

    @Override
    public void handleInvalidPacket(Packet packet) {
        if (kickMessage != null) {
            this.kickUser(kickMessage);
            kickMessage = null;
        } else {
            this.kickUser("Protocol error");
        }
    }

    public String getUserAndIPString() {
        if (this.username != null) {
            return this.username + " [" + this.netManager.getRemoteAddress().toString() + "]";
        }
        return this.netManager.getRemoteAddress().toString();
    }

    @Override
    public boolean isServerHandler() {
        return true;
    }

    public static String getServerId(LoginPacketHandler loginPacketHandler) {
        return loginPacketHandler.serverId;
    }

    public static LoginPacket setLoginPacket(LoginPacketHandler loginPacketHandler, LoginPacket loginPacket) {
        loginPacketHandler.loginPacket = loginPacket;
        return loginPacketHandler.loginPacket;
    }
}

