/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.world;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.BlockUpdatePacket;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.server.entity.player.ServerPlayer;
import net.minecraft.server.world.WorldServer;

public class ServerPlayerController {
    private WorldServer thisWorld;
    public Player player;
    private int blockHitTicks;
    private int currentlyMiningX;
    private int currentlyMiningY;
    private int currentlyMiningZ;
    private int ticksRan;
    private boolean destroyBlock;
    private int destroyX;
    private int destroyY;
    private int destroyZ;
    private Side destroySide;
    private int destroyBlockTicks;

    public ServerPlayerController(WorldServer worldserver) {
        this.thisWorld = worldserver;
    }

    public void tick() {
        ++this.ticksRan;
        if (this.destroyBlock) {
            int i = this.ticksRan - this.destroyBlockTicks;
            int j = this.thisWorld.getBlockId(this.destroyX, this.destroyY, this.destroyZ);
            if (j != 0) {
                Block block = Block.blocksList[j];
                float f = block.blockStrength(this.thisWorld, this.destroyX, this.destroyY, this.destroyZ, this.destroySide, this.player) * (float)(i + 1);
                if (f >= 1.0f) {
                    this.destroyBlock = false;
                    this.mineBlock(this.destroyX, this.destroyY, this.destroyZ, this.destroySide);
                }
            } else {
                this.destroyBlock = false;
            }
        }
    }

    public void startMining(int x, int y, int z, Side side) {
        if (!this.player.getGamemode().doBlockBreakingAnim()) {
            this.mineBlock(x, y, z, side);
            return;
        }
        this.blockHitTicks = this.ticksRan;
        Block block = this.thisWorld.getBlock(x, y, z);
        if (block != null && block.blockStrength(this.thisWorld, x, y, z, side, this.player) >= 1.0f) {
            this.mineBlock(x, y, z, side);
        } else {
            this.currentlyMiningX = x;
            this.currentlyMiningY = y;
            this.currentlyMiningZ = z;
        }
    }

    public void hitBlock(int x, int y, int z, Side side, double xHit, double yHit) {
        this.thisWorld.onBlockHit(this.player, x, y, z, side);
        Block block = this.thisWorld.getBlock(x, y, z);
        if (block != null) {
            block.onBlockLeftClicked(this.thisWorld, x, y, z, this.player, side, xHit, yHit);
        }
    }

    public boolean destroyBlock(int x, int y, int z, Side side) {
        if (x == this.currentlyMiningX && y == this.currentlyMiningY && z == this.currentlyMiningZ) {
            int l = this.ticksRan - this.blockHitTicks;
            int i1 = this.thisWorld.getBlockId(x, y, z);
            if (i1 != 0) {
                Block block = Block.blocksList[i1];
                float f = block.blockStrength(this.thisWorld, x, y, z, side, this.player) * (float)(l + 1);
                if (f >= 0.7f) {
                    return this.mineBlock(x, y, z, side);
                }
                if (!this.destroyBlock) {
                    this.destroyBlock = true;
                    this.destroyX = x;
                    this.destroyY = y;
                    this.destroyZ = z;
                    this.destroySide = side;
                    this.destroyBlockTicks = this.blockHitTicks;
                }
            }
        }
        return false;
    }

    public boolean removeBlock(int x, int y, int z) {
        Block block = Block.blocksList[this.thisWorld.getBlockId(x, y, z)];
        int l = this.thisWorld.getBlockMetadata(x, y, z);
        return this.thisWorld.setBlockWithNotify(x, y, z, 0);
    }

    public boolean mineBlock(int x, int y, int z, Side side) {
        ItemStack itemstack;
        ItemStack heldItemStack = this.player.getHeldItem();
        int id = this.thisWorld.getBlockId(x, y, z);
        int meta = this.thisWorld.getBlockMetadata(x, y, z);
        Item heldItem = null;
        if (heldItemStack != null) {
            heldItem = heldItemStack.getItem();
            if (!heldItemStack.beforeDestroyBlock(this.thisWorld, id, x, y, z, side, this.player)) {
                return false;
            }
        }
        Block block = Block.getBlock(id);
        BlockEntity blockEntity = this.thisWorld.getBlockEntity(x, y, z);
        this.thisWorld.playSoundEffect(this.player, 2001, x, y, z, id);
        boolean flag = this.removeBlock(x, y, z);
        if (flag && block != null) {
            block.onBlockDestroyedByPlayer(this.thisWorld, x, y, z, side, meta, this.player, heldItem);
        }
        if (flag && this.player.canHarvestBlock(Block.blocksList[id]) && this.player.getGamemode().dropBlockOnBreak()) {
            Block.blocksList[id].harvestBlock(this.thisWorld, this.player, x, y, z, meta, blockEntity);
            ((ServerPlayer)this.player).playerNetServerHandler.sendPacket(new BlockUpdatePacket(x, y, z, this.thisWorld));
        }
        if ((itemstack = this.player.getCurrentEquippedItem()) != null) {
            itemstack.onDestroyBlock(this.thisWorld, id, x, y, z, side, this.player);
            if (itemstack.stackSize <= 0) {
                this.player.destroyCurrentEquippedItem();
            }
        }
        return flag;
    }

    public boolean useItemOnNothing(Player entityplayer, World world, ItemStack itemstack) {
        if (!entityplayer.getGamemode().canInteract()) {
            return false;
        }
        int i = itemstack.stackSize;
        ItemStack itemstack1 = itemstack.useItemRightClick(world, entityplayer);
        if (itemstack1 != itemstack || itemstack1 != null && itemstack1.stackSize != i) {
            entityplayer.inventory.mainInventory[entityplayer.inventory.getCurrentItemIndex()] = itemstack1;
            if (itemstack1.stackSize <= 0) {
                entityplayer.inventory.mainInventory[entityplayer.inventory.getCurrentItemIndex()] = null;
            }
            return true;
        }
        return false;
    }

    public boolean activateBlockOrUseItem(Player entityplayer, World world, ItemStack itemstack, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (!entityplayer.getGamemode().canInteract()) {
            return false;
        }
        int blockId = world.getBlockId(blockX, blockY, blockZ);
        if (this.player.getHeldObject() == null) {
            BlockEntity blockEntity;
            if (this.player.isSneaking() && itemstack == null && (blockEntity = world.getBlockEntity(blockX, blockY, blockZ)) != null && blockEntity.canBeCarried(world, this.player)) {
                this.player.setHeldObject(blockEntity.pickup(world, this.player));
                return true;
            }
            if ((!this.player.isSneaking() || itemstack == null) && blockId > 0 && Block.blocksList[blockId].onBlockRightClicked(world, blockX, blockY, blockZ, this.player, side, xPlaced, yPlaced)) {
                return true;
            }
            if (itemstack == null) {
                return false;
            }
            return itemstack.useItem(this.player, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);
        }
        if (!this.player.isSneaking() && blockId > 0 && Block.blocksList[blockId].onBlockRightClicked(world, blockX, blockY, blockZ, this.player, side, xPlaced, yPlaced)) {
            return true;
        }
        boolean didPlace = this.player.getHeldObject().tryPlace(world, this.player, blockX, blockY, blockZ, side, xPlaced, yPlaced);
        if (didPlace) {
            this.player.setHeldObject(null);
        }
        return didPlace;
    }
}

