/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.bta.worldloader;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.NbtIo;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkLoaderLegacy;
import net.minecraft.core.world.chunk.reader.ChunkReader;
import net.minecraft.core.world.chunk.reader.ChunkReaderLegacy;
import net.minecraft.core.world.chunk.reader.ChunkReaderVersion1;
import net.minecraft.core.world.chunk.reader.ChunkReaderVersion2;
import net.minecraft.core.world.save.mcregion.RegionFileCache;
import org.slf4j.Logger;
import org.useless.seedviewer.collections.ChunkLocation;

public class ChunkLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final World dummyWorld = new World();
    private final File dimensionDir;

    public ChunkLoader(File worldFolder, int dimension) {
        this.dimensionDir = new File(worldFolder, "dimensions/" + dimension);
    }

    public boolean chunkExists(ChunkLocation location) {
        CompoundTag tag;
        DataInputStream regionStream = RegionFileCache.getChunkInputStream(this.dimensionDir, location.x, location.z);
        if (regionStream != null) {
            try {
                tag = NbtIo.read(regionStream);
            }
            catch (IOException e) {
                LOGGER.error("Failed to read tag for location {}, {}", location.x, location.z, e);
                return false;
            }
        } else {
            return false;
        }
        return tag.containsKey("Level");
    }

    public Chunk loadChunk(ChunkLocation location) throws IOException {
        DataInputStream regionStream = RegionFileCache.getChunkInputStream(this.dimensionDir, location.x, location.z);
        if (regionStream == null) {
            return null;
        }
        CompoundTag tag = NbtIo.read(regionStream);
        if (!tag.containsKey("Level")) {
            LOGGER.error("Chunk file at {},{} is missing level data, skipping", (Object)location.x, (Object)location.z);
            return null;
        }
        return ChunkLoader.loadChunkFromCompound(tag.getCompound("Level"));
    }

    public static Chunk loadChunkFromCompound(CompoundTag tag) {
        int version = tag.getIntegerOrDefault("Version", -1);
        ChunkReader reader = ChunkLoader.getChunkReaderByVersion(tag, version);
        int x = reader.getX();
        int z = reader.getZ();
        Chunk chunk = new Chunk(dummyWorld, x, z);
        chunk.heightMap = reader.getHeightMap();
        chunk.averageBlockHeight = reader.getAverageBlockHeight();
        chunk.isTerrainPopulated = reader.getIsTerrainPopulated();
        chunk.temperature = reader.getTemperatureMap();
        chunk.humidity = reader.getHumidityMap();
        Map<Integer, String> biomeRegistry = reader.getBiomeRegistry();
        for (int i = 0; i < 16; ++i) {
            ChunkLoaderLegacy.loadChunkSectionFromCompound(chunk.getSection(i), reader, biomeRegistry);
        }
        if (chunk.heightMap == null) {
            chunk.heightMap = new short[256];
            chunk.recalcHeightmap();
        }
        if (chunk.temperature == null || chunk.temperature.length == 0) {
            chunk.temperature = new double[256];
            Arrays.fill(chunk.temperature, Double.NEGATIVE_INFINITY);
        }
        if (chunk.humidity == null || chunk.humidity.length == 0) {
            chunk.humidity = new double[256];
            Arrays.fill(chunk.humidity, Double.NEGATIVE_INFINITY);
        }
        return chunk;
    }

    private static ChunkReader getChunkReaderByVersion(CompoundTag tag, int version) {
        switch (version) {
            case 1: {
                return new ChunkReaderVersion1(null, tag);
            }
            case 2: {
                return new ChunkReaderVersion2(null, tag);
            }
        }
        return new ChunkReaderLegacy(null, tag);
    }
}

