/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiElement;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.Listener;
import org.lwjgl.opengl.GL11;

public class ButtonElement
extends Gui
implements GuiElement {
    public static final int STATE_DISABLED = 0;
    public static final int STATE_DEFAULT = 1;
    public static final int STATE_HOVERED = 2;
    public int width;
    public int height;
    public int xPosition;
    public int yPosition;
    public String displayString;
    public IconCoordinate defaultTexture = TextureRegistry.getTexture("minecraft:gui/widgets/button");
    public IconCoordinate hoveredTexture = TextureRegistry.getTexture("minecraft:gui/widgets/button_highlighted");
    public IconCoordinate disabledTexture = TextureRegistry.getTexture("minecraft:gui/widgets/button_disabled");
    public int id;
    public boolean enabled = true;
    public boolean visible = true;
    public boolean playSound = true;
    public Listener<ButtonElement> listener;

    public ButtonElement(int id, int xPosition, int yPosition, String text) {
        this(id, xPosition, yPosition, 200, 20, text);
    }

    public ButtonElement(int id, int xPosition, int yPosition, int width, int height, String text) {
        this.id = id;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.displayString = text;
    }

    public ButtonElement setTextures(String defaultTexture, String hoveredTexture, String disabledTexture) {
        this.defaultTexture = TextureRegistry.getTexture(defaultTexture);
        this.hoveredTexture = TextureRegistry.getTexture(hoveredTexture);
        this.disabledTexture = TextureRegistry.getTexture(disabledTexture);
        return this;
    }

    protected int getButtonState(boolean hovered) {
        int state = 1;
        if (!this.enabled) {
            state = 0;
        } else if (hovered) {
            state = 2;
        }
        return state;
    }

    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        int textColor;
        IconCoordinate tex;
        if (!this.visible) {
            return;
        }
        Font font = mc.font;
        boolean mouseOver = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        int state = this.getButtonState(mouseOver);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (state) {
            case 0: {
                tex = this.disabledTexture;
                break;
            }
            case 2: {
                tex = this.hoveredTexture;
                break;
            }
            default: {
                tex = this.defaultTexture;
            }
        }
        this.drawGuiIcon(this.xPosition, this.yPosition, this.width, this.height, tex);
        this.mouseDragged(mc, mouseX, mouseY);
        switch (state) {
            case 0: {
                textColor = 0xA0A0A0;
                break;
            }
            case 1: {
                textColor = 0xE0E0E0;
                break;
            }
            default: {
                textColor = 0xFFFFA0;
            }
        }
        this.drawStringCentered(font, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, textColor);
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    public void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
    }

    public void mouseReleased(int mouseX, int mouseY) {
    }

    public boolean mouseClicked(Minecraft mc, int mouseX, int mouseY) {
        return this.enabled && mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    public ButtonElement setListener(Listener<ButtonElement> listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public void setX(int x) {
        this.xPosition = x;
    }

    @Override
    public void setY(int y) {
        this.yPosition = y;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getX() {
        return this.xPosition;
    }

    @Override
    public int getY() {
        return this.yPosition;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

