/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.b100.json.element.JsonArray;
import com.b100.json.element.JsonObject;
import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.render.texturepack.TexturePackException;
import net.minecraft.client.util.helper.TexturePackJsonHelper;
import net.minecraft.core.util.helper.Buffer;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;

public class MainMenuBackground {
    private static final Logger LOGGER = LogUtils.getLogger();
    public Minecraft mc;
    private final List<BackgroundListEntry> backgroundList = new ArrayList<BackgroundListEntry>();
    private final Random random = new Random();
    private Background currentBackground = null;
    private Background nextBackground = null;
    private final float displayTime = 20.0f;
    private final float fadeTime = 1.0f;
    private float currentDisplayTime = 0.0f;
    private long lastTick = 0L;

    public MainMenuBackground(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void draw() {
        if (this.backgroundList.isEmpty()) {
            return;
        }
        GL11.glClear((int)16384);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.backgroundList.size() == 1) {
            if (this.currentBackground == null) {
                this.currentBackground = this.loadRandomBackground();
            }
            OpenGLHelper.checkError("pre draw background");
            this.drawImage(this.currentBackground, 1.0f);
            OpenGLHelper.checkError("draw background");
            return;
        }
        OpenGLHelper.checkError("pre draw background");
        if (this.currentBackground == null) {
            this.currentBackground = this.loadRandomBackground();
        }
        if (this.nextBackground == null) {
            this.nextBackground = this.loadRandomBackground();
        }
        long now = System.currentTimeMillis();
        float delta = Math.min((float)(now - this.lastTick) / 1000.0f, 0.33f);
        this.lastTick = now;
        this.currentDisplayTime += delta;
        if (this.currentDisplayTime >= 21.0f) {
            this.currentDisplayTime = 0.0f;
            this.delete(this.currentBackground);
            this.currentBackground = this.nextBackground;
            this.nextBackground = null;
        }
        this.drawImage(this.currentBackground, 1.0f);
        float nextBackgroundAlpha = (this.currentDisplayTime - 20.0f) / 1.0f;
        if (nextBackgroundAlpha > 0.0f) {
            this.drawImage(this.nextBackground, nextBackgroundAlpha);
        }
        OpenGLHelper.checkError("draw background");
    }

    private Background loadRandomBackground() {
        BackgroundListEntry randomBackground = this.backgroundList.get(this.random.nextInt(this.backgroundList.size()));
        BufferedImage image = randomBackground.loadBackgroundImage();
        Buffer.put(image);
        int texture = GLAllocation.generateTexture();
        GL11.glBindTexture((int)3553, (int)texture);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)image.getWidth(), (int)image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        OpenGLHelper.checkError("setup background");
        return new Background(texture, image.getWidth(), image.getHeight());
    }

    private void drawImage(Background background, float alpha) {
        int y;
        int x;
        int h;
        int w;
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)background.texture);
        GL11.glColor4d((double)0.6, (double)0.6, (double)0.6, (double)alpha);
        int border = 1;
        int displayWidth = this.mc.resolution.getScaledWidthScreenCoords();
        int displayHeight = this.mc.resolution.getScaledHeightScreenCoords();
        int imageWidth = background.width - 2 * border;
        int imageHeight = background.height - 2 * border;
        float screenAspectRatio = (float)displayWidth / (float)displayHeight;
        float imageAspectRatio = (float)imageWidth / (float)imageHeight;
        if (screenAspectRatio > imageAspectRatio) {
            w = displayWidth;
            h = (int)((float)w / imageAspectRatio);
            x = 0;
            y = (displayHeight - h) / 2;
        } else {
            h = displayHeight;
            w = (int)((float)h * imageAspectRatio);
            x = (displayWidth - w) / 2;
            y = 0;
        }
        float uborder = (float)border / (float)background.width;
        float vborder = (float)border / (float)background.height;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(0.75f, 0.75f, 0.75f, alpha);
        tessellator.drawRectangleWithUV(x, y, w, h, uborder, vborder, 1.0 - (double)(uborder * 2.0f), 1.0 - (double)(vborder * 2.0f));
        tessellator.draw();
    }

    public void deleteTextures() {
        if (this.currentBackground != null) {
            this.delete(this.currentBackground);
            this.currentBackground = null;
        }
        if (this.nextBackground != null) {
            this.delete(this.nextBackground);
            this.nextBackground = null;
        }
    }

    private void delete(Background background) {
        GLAllocation.deleteTexture(background.texture);
    }

    public boolean isEnabled() {
        return !this.backgroundList.isEmpty();
    }

    public void refresh(List<Throwable> errors) {
        this.deleteTextures();
        this.backgroundList.clear();
        TexturePack defaultTexturePack = this.mc.texturePackList.getDefaultTexturePack();
        TexturePack currentTexturePack = this.mc.texturePackList.getHighestPriorityPack();
        this.loadBackgrounds(defaultTexturePack, errors);
        if (currentTexturePack != defaultTexturePack && currentTexturePack.hasFile("/bg/backgrounds.json")) {
            this.loadBackgrounds(currentTexturePack, errors);
        }
    }

    private void loadBackgrounds(TexturePack texturePack, List<Throwable> errors) {
        try {
            JsonObject rootObject = TexturePackJsonHelper.readJsonObject(texturePack, "/bg/backgrounds.json");
            if (rootObject.has("replace") && rootObject.getBoolean("replace")) {
                this.backgroundList.clear();
            }
            JsonArray backgrounds = TexturePackJsonHelper.getArray(rootObject, "backgrounds");
            try {
                for (int i = 0; i < backgrounds.length(); ++i) {
                    String name = backgrounds.get((int)i).getAsString().value;
                    if (!texturePack.hasFile("/bg/" + name + ".png")) {
                        LOGGER.warn("Skipping background '{}'", (Object)name);
                        continue;
                    }
                    this.backgroundList.add(new BackgroundListEntry(texturePack, name));
                }
            }
            catch (Exception e) {
                throw new TexturePackException("Error in background.json", e);
            }
        }
        catch (Exception e) {
            errors.add(e);
            this.backgroundList.clear();
        }
    }

    public void print() {
        LOGGER.info("Backgrounds: ");
        for (BackgroundListEntry bg : this.backgroundList) {
            LOGGER.info("    {}", (Object)bg);
        }
    }

    public void nextImage() {
        if (this.currentDisplayTime < 20.0f) {
            this.currentDisplayTime = 20.0f;
        }
    }

    static class Background {
        public int texture;
        public int width;
        public int height;

        public Background(int texture, int width, int height) {
            this.texture = texture;
            this.width = width;
            this.height = height;
        }
    }

    class BackgroundListEntry {
        public TexturePack texturePack;
        public String name;

        public BackgroundListEntry(TexturePack texturePack, String name) {
            this.texturePack = texturePack;
            this.name = name;
        }

        public BufferedImage loadBackgroundImage() {
            BufferedImage bufferedImage;
            block8: {
                InputStream stream = MainMenuBackground.this.mc.texturePackList.getResourceAsStream("/bg/" + this.name + ".png");
                try {
                    bufferedImage = ImageIO.read(stream);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                stream.close();
            }
            return bufferedImage;
        }

        public String toString() {
            return this.texturePack.manifest.getName() + "/" + this.name;
        }
    }
}

